/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginSpec;
import io.apiman.common.plugin.PluginUtils;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.i18n.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DefaultPluginRegistry
implements IPluginRegistry {
    private File pluginsDir;
    private Map<PluginCoordinates, Plugin> pluginCache = new HashMap<PluginCoordinates, Plugin>();
    private Map<PluginCoordinates, Throwable> errorCache = new HashMap<PluginCoordinates, Throwable>();
    private Set<URL> pluginRepositories;

    private static File createTempPluginsDir() {
        try {
            File tempDir = File.createTempFile("_apiman", "plugins");
            tempDir.delete();
            tempDir.mkdir();
            return tempDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getConfiguredPluginsDir(Map<String, String> configMap) {
        String pluginsDirPath = configMap.get("pluginsDir");
        if (pluginsDirPath != null) {
            File file = new File(pluginsDirPath).getAbsoluteFile();
            if (!file.exists()) {
                file.mkdirs();
            } else if (file.isFile()) {
                throw new RuntimeException("Invalid plugins directory: " + file.toString());
            }
            return file;
        }
        return DefaultPluginRegistry.createTempPluginsDir();
    }

    private static Set<URL> getConfiguredPluginRepositories(Map<String, String> configMap) {
        HashSet<URL> rval = new HashSet<URL>();
        rval.addAll(PluginUtils.getDefaultMavenRepositories());
        String repositories = configMap.get("pluginRepositories");
        if (repositories != null) {
            String[] split;
            for (String repository : split = repositories.split(",")) {
                try {
                    String trimmedRepo = repository.trim();
                    if (trimmedRepo.isEmpty()) continue;
                    rval.add(new URL(trimmedRepo));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public DefaultPluginRegistry() {
        this(DefaultPluginRegistry.createTempPluginsDir(), PluginUtils.getDefaultMavenRepositories());
    }

    public DefaultPluginRegistry(Map<String, String> configMap) {
        this(DefaultPluginRegistry.getConfiguredPluginsDir(configMap), DefaultPluginRegistry.getConfiguredPluginRepositories(configMap));
    }

    public DefaultPluginRegistry(File pluginsDir) {
        this(pluginsDir, PluginUtils.getDefaultMavenRepositories());
    }

    public DefaultPluginRegistry(File pluginsDir, Set<URL> pluginRepositories) {
        this.pluginsDir = pluginsDir;
        this.pluginRepositories = pluginRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPlugin(final PluginCoordinates coordinates, final IAsyncResultHandler<Plugin> userHandler) {
        final IAsyncResultHandler<Plugin> handler = new IAsyncResultHandler<Plugin>(){

            @Override
            public void handle(IAsyncResult<Plugin> result) {
                if (result.isError()) {
                    DefaultPluginRegistry.this.errorCache.put(coordinates, result.getError());
                } else {
                    DefaultPluginRegistry.this.pluginCache.put(coordinates, result.getResult());
                }
                userHandler.handle(result);
            }
        };
        Map<PluginCoordinates, Plugin> map = this.pluginCache;
        synchronized (map) {
            String pluginRelativePath;
            File pluginDir;
            boolean handled = false;
            if (this.pluginCache.containsKey(coordinates)) {
                userHandler.handle((Plugin)AsyncResultImpl.create(this.pluginCache.get(coordinates)));
                handled = true;
            }
            if (!handled && this.errorCache.containsKey(coordinates)) {
                userHandler.handle((Plugin)AsyncResultImpl.create(this.errorCache.get(coordinates), Plugin.class));
                handled = true;
            }
            if (!(pluginDir = new File(this.pluginsDir, pluginRelativePath = PluginUtils.getPluginRelativePath((PluginCoordinates)coordinates))).exists()) {
                pluginDir.mkdirs();
            }
            File pluginFile = new File(pluginDir, "plugin." + coordinates.getType());
            if (!handled && pluginFile.isFile()) {
                handled = true;
                try {
                    handler.handle((Plugin)AsyncResultImpl.create(this.readPluginFile(coordinates, pluginFile)));
                }
                catch (Exception error) {
                    handler.handle((Plugin)AsyncResultImpl.create(error));
                }
            }
            if (!handled) {
                File artifactFile;
                File m2Dir = PluginUtils.getUserM2Repository();
                String m2Override = System.getProperty("apiman.gateway.m2-repository-path");
                if (m2Override != null) {
                    m2Dir = new File(m2Override).getAbsoluteFile();
                }
                if (m2Dir != null && (artifactFile = PluginUtils.getM2Path((File)m2Dir, (PluginCoordinates)coordinates)).isFile()) {
                    handled = true;
                    try {
                        FileUtils.copyFile((File)artifactFile, (File)pluginFile);
                        handler.handle((Plugin)AsyncResultImpl.create(this.readPluginFile(coordinates, pluginFile)));
                    }
                    catch (Exception error) {
                        handler.handle((Plugin)AsyncResultImpl.create(error));
                    }
                }
            }
            if (!handled) {
                this.downloadPlugin(coordinates, new IAsyncResultHandler<File>(){

                    @Override
                    public void handle(IAsyncResult<File> result) {
                        if (result.isSuccess()) {
                            File downloadedArtifactFile = result.getResult();
                            if (downloadedArtifactFile == null || !downloadedArtifactFile.isFile()) {
                                handler.handle(AsyncResultImpl.create(new Exception(Messages.i18n.format("DefaultPluginRegistry.PluginNotFound", new Object[0]))));
                            } else {
                                try {
                                    File pluginFile;
                                    String pluginRelativePath = PluginUtils.getPluginRelativePath((PluginCoordinates)coordinates);
                                    File pluginDir = new File(DefaultPluginRegistry.this.pluginsDir, pluginRelativePath);
                                    if (!pluginDir.exists()) {
                                        pluginDir.mkdirs();
                                    }
                                    if (!(pluginFile = new File(pluginDir, "plugin." + coordinates.getType())).exists()) {
                                        FileUtils.moveFile((File)downloadedArtifactFile, (File)pluginFile);
                                    } else {
                                        FileUtils.deleteQuietly((File)downloadedArtifactFile);
                                    }
                                    handler.handle(AsyncResultImpl.create(DefaultPluginRegistry.this.readPluginFile(coordinates, pluginFile)));
                                }
                                catch (Exception error) {
                                    handler.handle(AsyncResultImpl.create(error));
                                }
                            }
                        } else {
                            handler.handle(AsyncResultImpl.create(result.getError()));
                        }
                    }
                });
            }
        }
    }

    protected Plugin readPluginFile(PluginCoordinates coordinates, File pluginFile) throws Exception {
        try {
            PluginClassLoader pluginClassLoader = this.createPluginClassLoader(pluginFile);
            URL specFile = pluginClassLoader.getResource("META-INF/apiman/plugin.json");
            if (specFile == null) {
                throw new Exception(Messages.i18n.format("DefaultPluginRegistry.MissingPluginSpecFile", new Object[]{"META-INF/apiman/plugin.json"}));
            }
            PluginSpec spec = PluginUtils.readPluginSpecFile((URL)specFile);
            Plugin plugin = new Plugin(spec, coordinates, pluginClassLoader);
            return plugin;
        }
        catch (Exception e) {
            throw new Exception(Messages.i18n.format("DefaultPluginRegistry.InvalidPlugin", new Object[]{pluginFile.getAbsolutePath()}), e);
        }
    }

    protected PluginClassLoader createPluginClassLoader(final File pluginFile) throws IOException {
        PluginClassLoader cl = new PluginClassLoader(pluginFile, Thread.currentThread().getContextClassLoader()){

            protected File createWorkDir(File pluginArtifactFile) throws IOException {
                File workDir = new File(pluginFile.getParentFile(), ".work");
                workDir.mkdirs();
                return workDir;
            }
        };
        return cl;
    }

    protected void downloadPlugin(final PluginCoordinates coordinates, final IAsyncResultHandler<File> handler) {
        if (this.pluginRepositories.isEmpty()) {
            handler.handle((File)((Object)AsyncResultImpl.create((File)null)));
            return;
        }
        final Iterator<URL> iterator = this.pluginRepositories.iterator();
        URL repoUrl = iterator.next();
        IAsyncResultHandler<File> handler2 = new IAsyncResultHandler<File>(){

            @Override
            public void handle(IAsyncResult<File> result) {
                if (result.isSuccess() && result.getResult() == null && iterator.hasNext()) {
                    DefaultPluginRegistry.this.downloadFromMavenRepo(coordinates, (URL)iterator.next(), this);
                } else {
                    handler.handle(result);
                }
            }
        };
        this.downloadFromMavenRepo(coordinates, repoUrl, handler2);
    }

    protected void downloadFromMavenRepo(PluginCoordinates coordinates, URL mavenRepoUrl, IAsyncResultHandler<File> handler) {
        String artifactSubPath = PluginUtils.getMavenPath((PluginCoordinates)coordinates);
        try {
            File tempArtifactFile = File.createTempFile("_plugin", "dwn");
            URL artifactUrl = new URL(mavenRepoUrl, artifactSubPath);
            this.downloadArtifactTo(artifactUrl, tempArtifactFile, handler);
        }
        catch (Exception e) {
            handler.handle((File)((Object)AsyncResultImpl.create(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadArtifactTo(URL artifactUrl, File pluginFile, IAsyncResultHandler<File> handler) {
        block7: {
            InputStream istream = null;
            FileOutputStream ostream = null;
            try {
                HttpURLConnection connection = (HttpURLConnection)artifactUrl.openConnection();
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    istream = connection.getInputStream();
                    ostream = new FileOutputStream(pluginFile);
                    IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                    ostream.flush();
                    handler.handle((File)((Object)AsyncResultImpl.create(pluginFile)));
                } else {
                    handler.handle((File)((Object)AsyncResultImpl.create(pluginFile)));
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                handler.handle((File)((Object)AsyncResultImpl.create(e)));
                break block7;
            }
            finally {
                IOUtils.closeQuietly(istream);
                IOUtils.closeQuietly(ostream);
            }
            IOUtils.closeQuietly((OutputStream)ostream);
        }
    }
}

