/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.policy;

import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.io.AbstractStream;
import io.apiman.gateway.engine.io.IAbortable;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.IReadWriteStream;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import java.util.Iterator;
import java.util.List;

public abstract class Chain<H>
extends AbstractStream<H>
implements IAbortable,
IPolicyChain<H>,
Iterable<PolicyWithConfiguration> {
    private final List<PolicyWithConfiguration> policies;
    private final IPolicyContext context;
    private IReadWriteStream<H> headPolicyHandler;
    private IAsyncHandler<PolicyFailure> policyFailureHandler;
    private IAsyncHandler<Throwable> policyErrorHandler;
    private Iterator<PolicyWithConfiguration> policyIterator;
    private H serviceObject;
    private boolean firstElem = true;

    public Chain(List<PolicyWithConfiguration> policies, IPolicyContext context) {
        this.policies = policies;
        this.context = context;
        this.policyIterator = this.iterator();
    }

    public void chainPolicyHandlers() {
        IReadWriteStream<H> previousHandler = null;
        for (PolicyWithConfiguration pwc : this) {
            IPolicy policy = pwc.getPolicy();
            final IReadWriteStream<H> handler = this.getServiceHandler(policy);
            if (handler == null) continue;
            if (this.headPolicyHandler == null) {
                this.headPolicyHandler = handler;
            }
            if (previousHandler != null) {
                previousHandler.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                    @Override
                    public void handle(IApimanBuffer result) {
                        handler.write(result);
                    }
                });
                previousHandler.endHandler(new IAsyncHandler<Void>(){

                    @Override
                    public void handle(Void result) {
                        handler.end();
                    }
                });
            }
            previousHandler = handler;
        }
        IReadWriteStream<H> tailPolicyHandler = previousHandler;
        if (this.headPolicyHandler != null && tailPolicyHandler != null) {
            tailPolicyHandler.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                @Override
                public void handle(IApimanBuffer chunk) {
                    Chain.this.handleBody(chunk);
                }
            });
            tailPolicyHandler.endHandler(new IAsyncHandler<Void>(){

                @Override
                public void handle(Void result) {
                    Chain.this.handleEnd();
                }
            });
        }
    }

    @Override
    public void doApply(H serviceObject) {
        try {
            this.serviceObject = serviceObject;
            if (this.firstElem) {
                this.chainPolicyHandlers();
                this.firstElem = false;
            }
            if (this.policyIterator.hasNext()) {
                this.applyPolicy(this.policyIterator.next(), this.getContext());
            } else {
                this.handleHead(this.getHead());
            }
        }
        catch (Throwable error) {
            this.throwError(error);
        }
    }

    @Override
    public void write(IApimanBuffer chunk) {
        if (this.finished) {
            throw new IllegalStateException("Attempted write after #end() was called.");
        }
        if (this.headPolicyHandler != null) {
            this.headPolicyHandler.write(chunk);
        } else {
            this.handleBody(chunk);
        }
    }

    @Override
    public void end() {
        if (this.headPolicyHandler != null) {
            this.headPolicyHandler.end();
        } else {
            this.handleEnd();
        }
    }

    @Override
    public H getHead() {
        return this.serviceObject;
    }

    @Override
    protected void handleHead(H service) {
        if (this.headHandler != null) {
            this.headHandler.handle(service);
        }
    }

    public void policyFailureHandler(IAsyncHandler<PolicyFailure> failureHandler) {
        this.policyFailureHandler = failureHandler;
    }

    @Override
    public void doFailure(PolicyFailure failure) {
        this.abort();
        this.policyFailureHandler.handle(failure);
    }

    public void policyErrorHandler(IAsyncHandler<Throwable> policyErrorHandler) {
        this.policyErrorHandler = policyErrorHandler;
    }

    @Override
    public void throwError(Throwable error) {
        this.abort();
        this.policyErrorHandler.handle(error);
    }

    @Override
    public void abort() {
    }

    protected abstract IReadWriteStream<H> getServiceHandler(IPolicy var1);

    protected abstract void applyPolicy(PolicyWithConfiguration var1, IPolicyContext var2);

    public List<PolicyWithConfiguration> getPolicies() {
        return this.policies;
    }

    protected IPolicyContext getContext() {
        return this.context;
    }
}

