/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.beans.exceptions.ComponentNotFoundException;
import io.apiman.gateway.engine.impl.ConfigDrivenEngineFactory;
import java.util.HashMap;
import java.util.Map;

public class ConfigDrivenComponentRegistry
implements IComponentRegistry {
    private IEngineConfig engineConfig;
    private Map<Class<? extends IComponent>, IComponent> components = new HashMap<Class<? extends IComponent>, IComponent>();

    public ConfigDrivenComponentRegistry(IEngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    @Override
    public <T extends IComponent> T getComponent(Class<T> componentType) throws ComponentNotFoundException {
        if (this.components.containsKey(componentType)) {
            return (T)this.components.get(componentType);
        }
        return this.createAndRegisterComponent(componentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IComponent> T createAndRegisterComponent(Class<T> componentType) throws ComponentNotFoundException {
        try {
            Map<Class<? extends IComponent>, IComponent> map = this.components;
            synchronized (map) {
                Class<T> componentClass = this.engineConfig.getComponentClass(componentType);
                Map<String, String> componentConfig = this.engineConfig.getComponentConfig(componentType);
                IComponent component = (IComponent)ConfigDrivenEngineFactory.create(componentClass, componentConfig);
                this.components.put(componentType, component);
                return (T)component;
            }
        }
        catch (Exception e) {
            throw new ComponentNotFoundException(componentType.getName());
        }
    }

    protected void addComponentMapping(Class<? extends IComponent> klazz, IComponent component) {
        this.components.put(klazz, component);
    }
}

