/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.metrics.impl.influxdb;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.exceptions.ConfigurationParseException;
import io.apiman.gateway.engine.components.IHttpClientComponent;
import io.apiman.gateway.engine.i18n.Messages;
import io.apiman.gateway.engine.metrics.RequestMetric;
import io.apiman.gateway.engine.metrics.impl.influxdb.InfluxDb09Driver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

public class InfluxDb09Metrics
implements IMetrics {
    private static final String INFLUX_ENDPOINT = "endpoint";
    private static final String DATABASE = "database";
    private static final String RETENTION_POLICY = "retentionPolicy";
    private static final String POINTS = "points";
    private static final String TIMESTAMP = "time";
    private static final String SERIES_NAME = "name";
    private static final String TAGS = "tags";
    private static final String FIELDS = "fields";
    private static final Map<String, String> DEFAULT_TAGS = new LinkedHashMap<String, String>();
    private static TimeZone tz;
    private static DateFormat iso8601;
    private JsonFactory jsonFactory = new JsonFactory();
    private Map<String, String> config;
    private String dbName;
    private String retentionPolicy;
    private String seriesName;
    private String influxEndpoint;
    private IHttpClientComponent httpClient;
    private InfluxDb09Driver driver;
    private String username;
    private String password;

    public InfluxDb09Metrics(Map<String, String> config) {
        this.config = config;
        this.influxEndpoint = this.getMandatoryString(INFLUX_ENDPOINT);
        this.dbName = this.getMandatoryString(DATABASE);
        this.retentionPolicy = this.getOptionalString(RETENTION_POLICY, null);
        this.seriesName = this.getMandatoryString(SERIES_NAME);
        this.username = this.getMandatoryString("username");
        this.password = this.getMandatoryString("password");
    }

    public void initialize() {
        this.driver = new InfluxDb09Driver(this.httpClient, this.influxEndpoint, this.username, this.password);
        if (!this.listDatabases().contains(this.dbName)) {
            throw new ConfigurationParseException(Messages.i18n.format("InfluxDb09Metrics.databaseDoesNotExist", new Object[]{this.dbName}));
        }
    }

    @Override
    public void record(RequestMetric metric) {
        this.driver.write(this.buildJsonRequest(metric), "utf-8", new IAsyncHandler<InfluxDb09Driver.InfluxException>(){

            @Override
            public void handle(InfluxDb09Driver.InfluxException result) {
            }
        });
    }

    @Override
    public void setComponentRegistry(IComponentRegistry registry) {
        this.httpClient = registry.getComponent(IHttpClientComponent.class);
    }

    protected String buildJsonRequest(RequestMetric metric) {
        StringWriter out = new StringWriter(500);
        try {
            JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)out);
            generator.writeStartObject();
            generator.writeStringField(DATABASE, this.dbName);
            if (this.retentionPolicy != null) {
                generator.writeStringField(RETENTION_POLICY, this.retentionPolicy);
            }
            generator.writeArrayFieldStart(POINTS);
            generator.writeStartObject();
            this.writeDate(generator, TIMESTAMP, new Date());
            generator.writeStringField(SERIES_NAME, this.seriesName);
            generator.writeObjectFieldStart(TAGS);
            this.putAllFields(generator, DEFAULT_TAGS.entrySet());
            generator.writeStringField("serviceOrgId", metric.getServiceOrgId());
            generator.writeStringField("serviceId", metric.getServiceId());
            generator.writeStringField("serviceVersion", metric.getServiceVersion());
            generator.writeStringField("applicationOrgId", metric.getApplicationOrgId());
            generator.writeStringField("applicationId", metric.getApplicationId());
            generator.writeStringField("applicationVersion", metric.getApplicationVersion());
            generator.writeStringField("contractId", metric.getContractId());
            generator.writeEndObject();
            generator.writeObjectFieldStart(FIELDS);
            this.writeDate(generator, "requestStart", metric.getRequestStart());
            this.writeDate(generator, "requestEnd", metric.getRequestEnd());
            generator.writeNumberField("requestDuration", metric.getRequestDuration());
            this.writeDate(generator, "serviceStart", metric.getServiceStart());
            this.writeDate(generator, "serviceEnd", metric.getServiceEnd());
            generator.writeNumberField("serviceDuration", metric.getServiceDuration());
            generator.writeStringField("resource", metric.getResource());
            generator.writeStringField("method", metric.getMethod());
            generator.writeNumberField("responseCode", metric.getResponseCode());
            generator.writeStringField("responseMessage", metric.getResponseMessage());
            generator.writeNumberField("failureCode", metric.getFailureCode());
            generator.writeStringField("failureReason", metric.getFailureReason());
            generator.writeBooleanField("error", metric.isError());
            generator.writeStringField("errorMessage", metric.getErrorMessage());
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndArray();
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    private void writeDate(JsonGenerator generator, String fieldName, Date date) throws JsonGenerationException, IOException {
        generator.writeStringField(fieldName, iso8601.format(date));
    }

    private void putAllFields(JsonGenerator generator, Set<Map.Entry<String, String>> entrySet) throws JsonGenerationException, IOException {
        for (Map.Entry<String, String> entry : entrySet) {
            generator.writeStringField(entry.getKey(), entry.getValue());
        }
    }

    private String getMandatoryString(String keyname) {
        String value = this.config.get(keyname);
        if (value == null) {
            throw new ConfigurationParseException(Messages.i18n.format("InfluxDb09Metrics.mandatoryConfigMustBeSet", new Object[]{this.getClass().getCanonicalName(), keyname}));
        }
        return keyname;
    }

    private String getOptionalString(String key, String dValue) {
        return this.config.containsKey(key) ? this.config.get(key) : dValue;
    }

    private List<String> listDatabases() {
        final CountDownLatch endSignal = new CountDownLatch(1);
        final ArrayList<String> results = new ArrayList<String>();
        this.driver.listDatabases(new IAsyncResultHandler<List<String>>(){

            @Override
            public void handle(IAsyncResult<List<String>> result) {
                if (!result.isSuccess()) {
                    throw (InfluxDb09Driver.InfluxException)result.getError();
                }
                results.addAll((Collection)result.getResult());
                endSignal.countDown();
            }
        });
        try {
            endSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return results;
    }

    static {
        DEFAULT_TAGS.put("component", "apiman-gatway");
        tz = TimeZone.getTimeZone("UTC");
        iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        iso8601.setTimeZone(tz);
    }
}

