/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.metrics.impl.influxdb;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.exceptions.ConfigurationParseException;
import io.apiman.gateway.engine.components.IHttpClientComponent;
import io.apiman.gateway.engine.components.http.IHttpClientResponse;
import io.apiman.gateway.engine.i18n.Messages;
import io.apiman.gateway.engine.metrics.RequestMetric;
import io.apiman.gateway.engine.metrics.impl.influxdb.InfluxDb09Driver;
import io.apiman.gateway.engine.metrics.impl.influxdb.InfluxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class InfluxDb09Metrics
implements IMetrics {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String INFLUX_ENDPOINT = "endpoint";
    private static final String DATABASE = "database";
    private static final String RETENTION_POLICY = "retentionPolicy";
    private static final String SERIES_NAME = "measurement";
    private static final String TIMEPRECISION = "ms";
    private static final Map<String, String> DEFAULT_TAGS = new LinkedHashMap<String, String>();
    private String dbName;
    private String retentionPolicy;
    private String seriesName;
    private String influxEndpoint;
    private IHttpClientComponent httpClient;
    private InfluxDb09Driver driver;
    private String username;
    private String password;

    public InfluxDb09Metrics(Map<String, String> config) {
        this.influxEndpoint = this.getMandatoryString(config, INFLUX_ENDPOINT);
        this.dbName = this.getMandatoryString(config, DATABASE);
        this.retentionPolicy = this.getOptionalString(config, RETENTION_POLICY, null);
        this.seriesName = this.getMandatoryString(config, SERIES_NAME);
        this.username = this.getOptionalString(config, USERNAME, null);
        this.password = this.getOptionalString(config, PASSWORD, null);
    }

    public void initialize() {
        this.driver = new InfluxDb09Driver(this.httpClient, this.influxEndpoint, this.username, this.password, this.dbName, this.retentionPolicy, TIMEPRECISION);
        if (!this.listDatabases().contains(this.dbName)) {
            throw new ConfigurationParseException(Messages.i18n.format("InfluxDb09Metrics.databaseDoesNotExist", new Object[]{this.dbName}));
        }
    }

    @Override
    public void setComponentRegistry(IComponentRegistry registry) {
        this.httpClient = registry.getComponent(IHttpClientComponent.class);
    }

    @Override
    public void record(RequestMetric metric) {
        this.driver.write(this.buildRequest(metric), new IAsyncHandler<InfluxException>(){

            @Override
            public void handle(InfluxException result) {
                if (result.isBadResponse()) {
                    IHttpClientResponse response = result.getResponse();
                    System.err.println(String.format("Influx stats error. Code: %s with message: '%s'", response.getResponseCode(), response.getResponseMessage()));
                } else {
                    System.err.println(result.getMessage());
                }
            }
        });
    }

    protected String buildRequest(RequestMetric metric) {
        StringBuilder sb = new StringBuilder(500);
        sb.append(this.seriesName + ",");
        for (Map.Entry<String, String> entry : DEFAULT_TAGS.entrySet()) {
            this.write(entry.getKey(), entry.getValue(), sb);
        }
        this.write("serviceOrgId", this.quote(metric.getServiceOrgId()), sb);
        this.write("serviceId", this.quote(metric.getServiceId()), sb);
        this.write("serviceVersion", this.quote(metric.getServiceVersion()), sb);
        this.write("applicationOrgId", this.quote(metric.getApplicationOrgId()), sb);
        this.write("applicationId", this.quote(metric.getApplicationId()), sb);
        this.write("applicationVersion", this.quote(metric.getApplicationVersion()), sb);
        this.write("contractId", this.quote(metric.getContractId()), sb);
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
        this.write("requestStart", this.dateToLong(metric.getRequestStart()), sb);
        this.write("requestEnd", this.dateToLong(metric.getRequestEnd()), sb);
        this.write("serviceStart", this.dateToLong(metric.getServiceStart()), sb);
        this.write("serviceEnd", this.dateToLong(metric.getServiceEnd()), sb);
        this.write("resource", this.quote(metric.getResource()), sb);
        this.write("method", this.quote(metric.getMethod()), sb);
        this.write("responseCode", Integer.toString(metric.getResponseCode()), sb);
        this.write("responseMessage", this.quote(metric.getResponseMessage()), sb);
        this.write("failureCode", Integer.toString(metric.getFailureCode()), sb);
        this.write("failureReason", this.quote(metric.getFailureReason()), sb);
        this.write("error", Boolean.toString(metric.isError()), sb);
        this.write("errorMessage", this.quote(metric.getErrorMessage()), sb);
        sb.deleteCharAt(sb.length() - 1);
        sb.append(' ');
        sb.append(System.currentTimeMillis());
        return sb.toString();
    }

    private void write(String tagname, String tagValue, StringBuilder sb) {
        if (tagValue == null) {
            return;
        }
        sb.append(tagname + "=" + tagValue + ",");
    }

    private String quote(String item) {
        if (item == null) {
            return null;
        }
        return "\"" + item + "\"";
    }

    private String dateToLong(Date date) {
        return Long.toString(date.getTime());
    }

    private String getMandatoryString(Map<String, String> config, String keyname) {
        String value = config.get(keyname);
        if (value == null) {
            throw new ConfigurationParseException(Messages.i18n.format("InfluxDb09Metrics.mandatoryConfigMustBeSet", new Object[]{this.getClass().getCanonicalName(), keyname}));
        }
        return value;
    }

    private String getOptionalString(Map<String, String> config, String key, String dValue) {
        return config.containsKey(key) ? config.get(key) : dValue;
    }

    private List<String> listDatabases() {
        final CountDownLatch endSignal = new CountDownLatch(1);
        final ArrayList<String> results = new ArrayList<String>();
        this.driver.listDatabases(new IAsyncResultHandler<List<String>>(){

            @Override
            public void handle(IAsyncResult<List<String>> result) {
                if (!result.isSuccess()) {
                    throw new InfluxException(result.getError());
                }
                results.addAll((Collection)result.getResult());
                endSignal.countDown();
            }
        });
        try {
            endSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return results;
    }

    static {
        DEFAULT_TAGS.put("generator", "apiman-gateway");
    }
}

