/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.impl.AbstractEngineFactory;
import io.apiman.gateway.engine.impl.ConfigDrivenComponentRegistry;
import io.apiman.gateway.engine.impl.SecureRegistryWrapper;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import java.lang.reflect.Constructor;
import java.util.Map;

public class ConfigDrivenEngineFactory
extends AbstractEngineFactory {
    private IEngineConfig engineConfig;

    public ConfigDrivenEngineFactory(IEngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    @Override
    protected IPluginRegistry createPluginRegistry() {
        Class<? extends IPluginRegistry> c = this.engineConfig.getPluginRegistryClass();
        Map<String, String> config = this.engineConfig.getPluginRegistryConfig();
        return ConfigDrivenEngineFactory.create(c, config);
    }

    @Override
    protected IRegistry createRegistry(IPluginRegistry pluginRegistry) {
        Class<? extends IRegistry> c = this.engineConfig.getRegistryClass(pluginRegistry);
        Map<String, String> config = this.engineConfig.getRegistryConfig();
        IRegistry registry = ConfigDrivenEngineFactory.create(c, config);
        return new SecureRegistryWrapper(registry);
    }

    @Override
    protected IComponentRegistry createComponentRegistry(IPluginRegistry pluginRegistry) {
        return new ConfigDrivenComponentRegistry(this.engineConfig, pluginRegistry);
    }

    @Override
    protected IConnectorFactory createConnectorFactory(IPluginRegistry pluginRegistry) {
        Class<? extends IConnectorFactory> c = this.engineConfig.getConnectorFactoryClass(pluginRegistry);
        Map<String, String> config = this.engineConfig.getConnectorFactoryConfig();
        return ConfigDrivenEngineFactory.create(c, config);
    }

    @Override
    protected IPolicyFactory createPolicyFactory(IPluginRegistry pluginRegistry) {
        Class<? extends IPolicyFactory> c = this.engineConfig.getPolicyFactoryClass(pluginRegistry);
        Map<String, String> config = this.engineConfig.getPolicyFactoryConfig();
        return ConfigDrivenEngineFactory.create(c, config);
    }

    @Override
    protected IMetrics createMetrics(IPluginRegistry pluginRegistry) {
        Class<? extends IMetrics> c = this.engineConfig.getMetricsClass(pluginRegistry);
        Map<String, String> config = this.engineConfig.getMetricsConfig();
        return ConfigDrivenEngineFactory.create(c, config);
    }

    protected static <T> T create(Class<T> type, Map<String, String> config) {
        try {
            Constructor<T> constructor = type.getConstructor(Map.class);
            return constructor.newInstance(config);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

