/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.IRequiresInitialization;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.Version;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.impl.ServiceRequestExecutorImpl;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import io.apiman.gateway.engine.policy.PolicyContextImpl;

public class EngineImpl
implements IEngine {
    private IRegistry registry;
    private IPluginRegistry pluginRegistry;
    private IComponentRegistry componentRegistry;
    private IConnectorFactory connectorFactory;
    private IPolicyFactory policyFactory;
    private IMetrics metrics;

    public EngineImpl(IRegistry registry, IPluginRegistry pluginRegistry, IComponentRegistry componentRegistry, IConnectorFactory connectorFactory, IPolicyFactory policyFactory, IMetrics metrics) {
        this.setRegistry(registry);
        this.setPluginRegistry(pluginRegistry);
        this.setComponentRegistry(componentRegistry);
        this.setConnectorFactory(connectorFactory);
        this.setPolicyFactory(policyFactory);
        this.setMetrics(metrics);
        policyFactory.setPluginRegistry(pluginRegistry);
        metrics.setComponentRegistry(componentRegistry);
        this.initialize(registry, pluginRegistry, componentRegistry, connectorFactory, policyFactory, metrics);
    }

    @Override
    public String getVersion() {
        return Version.get().getVersionString();
    }

    @Override
    public IServiceRequestExecutor executor(ServiceRequest request, IAsyncResultHandler<IEngineResult> resultHandler) {
        return new ServiceRequestExecutorImpl(request, resultHandler, this.registry, new PolicyContextImpl(this.getComponentRegistry()), this.policyFactory, this.getConnectorFactory(), this.getMetrics());
    }

    @Override
    public IRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IRegistry registry) {
        this.registry = registry;
    }

    public IConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public void setConnectorFactory(IConnectorFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    public IPolicyFactory getPolicyFactory() {
        return this.policyFactory;
    }

    public void setPolicyFactory(IPolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    public IComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(IComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public IPluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void setPluginRegistry(IPluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public IMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(IMetrics metrics) {
        this.metrics = metrics;
    }

    private void initialize(Object ... m) {
        for (Object o : m) {
            if (!(o instanceof IRequiresInitialization)) continue;
            ((IRequiresInitialization)o).initialize();
        }
    }
}

