/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.metrics.impl.influxdb;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IHttpClientComponent;
import io.apiman.gateway.engine.components.http.HttpMethod;
import io.apiman.gateway.engine.components.http.IHttpClientRequest;
import io.apiman.gateway.engine.components.http.IHttpClientResponse;
import io.apiman.gateway.engine.metrics.impl.influxdb.InfluxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class InfluxDb09Driver {
    private IHttpClientComponent httpClient;
    private StringBuilder writeUrl;
    private StringBuilder queryUrl;
    private String username;
    private String password;
    private String database;
    private String retentionPolicy;
    private String timePrecision;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public InfluxDb09Driver(IHttpClientComponent httpClient, String endpoint, String username, String password, String database, String retentionPolicy, String timePrecision) {
        this.httpClient = httpClient;
        this.username = username;
        this.password = password;
        this.database = database;
        this.retentionPolicy = retentionPolicy;
        this.timePrecision = timePrecision;
        StringBuilder writeEndpoint = new StringBuilder();
        if (!endpoint.startsWith("http://") || !endpoint.startsWith("https://")) {
            writeEndpoint.append("http://");
        }
        writeEndpoint.append(endpoint);
        StringBuilder queryEndpoint = new StringBuilder().append((CharSequence)writeEndpoint).append("/query");
        this.queryUrl = this.buildParams(queryEndpoint, "SHOW DATABASES");
        writeEndpoint.append("/write");
        this.writeUrl = this.buildParams(writeEndpoint, null);
    }

    public void write(String lineDocument, final IAsyncHandler<InfluxException> failureHandler) {
        IHttpClientRequest request = this.httpClient.request(this.writeUrl.toString(), HttpMethod.POST, new IAsyncResultHandler<IHttpClientResponse>(){

            @Override
            public void handle(IAsyncResult<IHttpClientResponse> result) {
                if (result.isError() || result.getResult().getResponseCode() < 200 || result.getResult().getResponseCode() > 299) {
                    failureHandler.handle(new InfluxException(result.getResult()));
                }
            }
        });
        request.addHeader("Content-Type", "text/plain");
        request.write(lineDocument, StandardCharsets.UTF_8.name());
        request.end();
    }

    public void listDatabases(final IAsyncResultHandler<List<String>> handler) {
        IHttpClientRequest request = this.httpClient.request(this.queryUrl.toString(), HttpMethod.GET, new IAsyncResultHandler<IHttpClientResponse>(){

            @Override
            public void handle(IAsyncResult<IHttpClientResponse> result) {
                try {
                    if (result.isError() || result.getResult().getResponseCode() != 200) {
                        InfluxDb09Driver.this.handleError(result, handler);
                        return;
                    }
                    ArrayList results = new ArrayList();
                    JsonNode arrNode = (JsonNode)((JsonNode)objectMapper.readTree(result.getResult().getBody()).path("results").getElements().next()).path("series").getElements().next();
                    InfluxDb09Driver.this.flattenArrays(arrNode.get("values"), results);
                    handler.handle(AsyncResultImpl.create(results));
                }
                catch (IOException e) {
                    AsyncResultImpl.create(new RuntimeException("Unable to parse Influx JSON response", e));
                }
            }
        });
        request.end();
    }

    protected <T> void handleError(IAsyncResult<IHttpClientResponse> result, IAsyncResultHandler<T> handler) {
        if (result.isError()) {
            handler.handle(AsyncResultImpl.create(result.getError()));
        } else if (result.getResult().getResponseCode() != 200) {
            handler.handle(AsyncResultImpl.create(new InfluxException("Influx: " + result.getResult().getResponseCode() + " " + result.getResult().getResponseMessage())));
        }
    }

    private void flattenArrays(JsonNode arrNode, List<String> results) {
        if (arrNode.isArray()) {
            for (JsonNode entry : arrNode) {
                this.flattenArrays(entry, results);
            }
        } else {
            results.add(arrNode.getTextValue());
        }
    }

    private StringBuilder buildParams(StringBuilder url, String query) {
        this.addQueryParam(url, "db", this.database, "?");
        this.addQueryParam(url, "u", this.username, "&");
        this.addQueryParam(url, "p", this.password, "&");
        this.addQueryParam(url, "rp", this.retentionPolicy, "&");
        this.addQueryParam(url, "precision", this.timePrecision, "&");
        this.addQueryParam(url, "q", query, "&");
        return url;
    }

    private void addQueryParam(StringBuilder url, String key, String value, String connector) {
        if (value == null) {
            return;
        }
        try {
            url.append(connector + key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

