/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.io.IApimanBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CachedResponse {
    private static final Path tmpDir;
    private String id;
    private Map<String, String> headers;
    private int code;
    private String message;
    private boolean writeFailed = false;
    private File tmpFile;
    private FileOutputStream fileOS;
    private FileInputStream fileIS;

    public CachedResponse(String id) {
        this.id = id;
        this.tmpFile = new File(tmpDir.toFile(), "response" + id.hashCode() + ".apiman");
    }

    public String getId() {
        return this.id;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = new HashMap<String, String>(headers.size());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void write(IApimanBuffer chunk) {
        if (this.fileOS == null) {
            try {
                this.fileOS = new FileOutputStream(this.tmpFile);
                this.fileOS.write(chunk.getBytes());
            }
            catch (IOException e) {
                this.writeFailed = true;
            }
        }
    }

    public void endWrite() {
        IOUtils.closeQuietly((OutputStream)this.fileOS);
        this.fileOS = null;
    }

    public InputStream getInputStream() throws IOException {
        this.fileIS = new FileInputStream(this.tmpFile);
        return this.fileIS;
    }

    public boolean isWriteFailed() {
        return this.writeFailed;
    }

    static {
        try {
            tmpDir = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

