/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.beans.exceptions.ComponentNotFoundException;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.components.IPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.impl.DefaultPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.impl.InMemoryCacheStoreComponent;
import io.apiman.gateway.engine.impl.InMemoryRateLimiterComponent;
import io.apiman.gateway.engine.impl.InMemorySharedStateComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultComponentRegistry
implements IComponentRegistry {
    private Map<Class<? extends IComponent>, IComponent> components = new HashMap<Class<? extends IComponent>, IComponent>();

    public DefaultComponentRegistry() {
        this.registerSharedStateComponent();
        this.registerRateLimiterComponent();
        this.registerPolicyFailureFactoryComponent();
        this.registerHttpClientComponent();
        this.registerBufferFactoryComponent();
        this.registerCacheStoreComponent();
    }

    @Override
    public Collection<IComponent> getComponents() {
        return this.components.values();
    }

    protected void registerHttpClientComponent() {
    }

    protected void registerBufferFactoryComponent() {
    }

    protected void registerPolicyFailureFactoryComponent() {
        this.addComponent(IPolicyFailureFactoryComponent.class, new DefaultPolicyFailureFactoryComponent());
    }

    protected void registerRateLimiterComponent() {
        this.addComponent(IRateLimiterComponent.class, new InMemoryRateLimiterComponent());
    }

    protected void registerSharedStateComponent() {
        this.addComponent(ISharedStateComponent.class, new InMemorySharedStateComponent());
    }

    protected void registerCacheStoreComponent() {
        this.addComponent(ICacheStoreComponent.class, new InMemoryCacheStoreComponent());
    }

    protected <T extends IComponent> void addComponent(Class<T> componentType, T component) {
        this.components.put(componentType, component);
    }

    @Override
    public <T extends IComponent> T getComponent(Class<T> componentType) throws ComponentNotFoundException {
        if (this.components.containsKey(componentType)) {
            return (T)this.components.get(componentType);
        }
        throw new ComponentNotFoundException(componentType.getName());
    }
}

