/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.io;

import io.apiman.gateway.engine.io.IApimanBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteBuffer
implements IApimanBuffer {
    private byte[] buffer;
    private int bytesInBuffer = 0;

    public ByteBuffer(byte[] buffer, int size) {
        this.buffer = buffer;
        this.bytesInBuffer = size;
    }

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public ByteBuffer(String stringData) {
        this.buffer = stringData.getBytes();
        this.bytesInBuffer = this.buffer.length;
    }

    public ByteBuffer(String stringData, String enc) {
        try {
            this.buffer = stringData.getBytes(enc);
            this.bytesInBuffer = this.buffer.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer(byte[] byteData) {
        this.buffer = Arrays.copyOf(byteData, byteData.length);
        this.bytesInBuffer = byteData.length;
    }

    @Override
    public Object getNativeBuffer() {
        return this.buffer;
    }

    @Override
    public int length() {
        return this.bytesInBuffer;
    }

    @Override
    public void insert(int index, IApimanBuffer buffer) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void insert(int index, IApimanBuffer buffer, int offset, int length) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void append(IApimanBuffer buffer) {
        this.append(buffer, 0, buffer.length());
    }

    @Override
    public void append(IApimanBuffer buffer, int offset, int length) {
        int sizeToAppend = length;
        int newBufferSize = this.bytesInBuffer + sizeToAppend;
        if (this.buffer.length >= newBufferSize) {
            System.arraycopy(buffer.getBytes(), offset, this.buffer, this.bytesInBuffer, sizeToAppend);
        } else {
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.bytesInBuffer);
            System.arraycopy(buffer.getBytes(), offset, newBuffer, this.bytesInBuffer, sizeToAppend);
            this.buffer = newBuffer;
        }
        this.bytesInBuffer = newBufferSize;
    }

    @Override
    public byte get(int index) {
        return this.buffer[index];
    }

    @Override
    public void set(int index, byte b) {
        this.buffer[index] = b;
    }

    @Override
    public void append(byte b) {
        byte[] bytes = new byte[]{b};
        this.append(bytes);
    }

    @Override
    public byte[] getBytes() {
        byte[] rval = new byte[this.bytesInBuffer];
        System.arraycopy(this.buffer, 0, rval, 0, this.bytesInBuffer);
        return rval;
    }

    @Override
    public byte[] getBytes(int start, int end) {
        int size = end - start;
        byte[] rval = new byte[size];
        System.arraycopy(this.buffer, start, rval, 0, size);
        return rval;
    }

    @Override
    public void insert(int index, byte[] b) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void insert(int index, byte[] b, int offset, int length) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void append(byte[] bytes) {
        int requiredBytes = this.bytesInBuffer + bytes.length;
        if (requiredBytes > this.buffer.length) {
            byte[] oldbuffer = this.buffer;
            this.buffer = new byte[requiredBytes];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, this.bytesInBuffer);
        }
        System.arraycopy(bytes, 0, this.buffer, this.bytesInBuffer, bytes.length);
        this.bytesInBuffer = requiredBytes;
    }

    @Override
    public void append(byte[] bytes, int offset, int length) {
        int requiredBytes = this.bytesInBuffer + length;
        if (requiredBytes > this.buffer.length) {
            byte[] oldbuffer = this.buffer;
            this.buffer = new byte[requiredBytes];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, this.bytesInBuffer);
        }
        System.arraycopy(bytes, offset, this.buffer, this.bytesInBuffer, length);
        this.bytesInBuffer = requiredBytes;
    }

    @Override
    public String getString(int start, int end) {
        return new String(this.getBytes(start, end));
    }

    @Override
    public String getString(int start, int end, String encoding) {
        try {
            return new String(this.getBytes(start, end), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void insert(int index, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void insert(int index, String string, String encoding) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void append(String string) {
        byte[] bytes = string.getBytes();
        this.append(bytes);
    }

    @Override
    public void append(String string, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = string.getBytes(encoding);
        this.append(bytes);
    }

    @Override
    public String toString(String encoding) {
        try {
            return new String(this.buffer, 0, this.bytesInBuffer, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.bytesInBuffer);
    }

    public int getBytesInBuffer() {
        return this.bytesInBuffer;
    }

    public int readFrom(InputStream stream) throws IOException {
        int bytesRead = stream.read(this.buffer);
        this.bytesInBuffer = bytesRead < 0 ? 0 : bytesRead;
        return bytesRead;
    }
}

