/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.policy;

import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.io.IReadWriteStream;
import io.apiman.gateway.engine.policy.Chain;
import io.apiman.gateway.engine.policy.IDataPolicy;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import java.util.Iterator;
import java.util.List;

public class RequestChain
extends Chain<ServiceRequest> {
    public RequestChain(List<PolicyWithConfiguration> policies, IPolicyContext context) {
        super(policies, context);
    }

    @Override
    public Iterator<PolicyWithConfiguration> iterator() {
        return new RequestIterator(this.getPolicies());
    }

    @Override
    protected IReadWriteStream<ServiceRequest> getServiceHandler(IPolicy policy, Object config) {
        if (policy instanceof IDataPolicy) {
            return ((IDataPolicy)policy).getRequestDataHandler((ServiceRequest)this.getHead(), this.getContext(), config);
        }
        return null;
    }

    @Override
    protected void applyPolicy(PolicyWithConfiguration policy, IPolicyContext context) {
        policy.getPolicy().apply((ServiceRequest)this.getHead(), context, policy.getConfiguration(), this);
    }

    private class RequestIterator
    implements Iterator<PolicyWithConfiguration> {
        private List<PolicyWithConfiguration> policies;
        private int index;

        public RequestIterator(List<PolicyWithConfiguration> policies) {
            this.policies = policies;
            this.index = 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PolicyWithConfiguration next() {
            return this.policies.get(this.index++);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.policies.size();
        }
    }
}

