/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.HashMap;
import java.util.Map;

public class InMemoryRateLimiterComponent
implements IRateLimiterComponent {
    private Map<String, RateLimiterBucket> buckets = new HashMap<String, RateLimiterBucket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        RateLimiterBucket bucket = null;
        Map<String, RateLimiterBucket> map = this.buckets;
        synchronized (map) {
            bucket = this.buckets.get(bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.buckets.put(bucketId, bucket);
            }
            bucket.resetIfNecessary(period);
            RateLimitResponse response = new RateLimitResponse();
            if (bucket.getCount() > limit) {
                response.setAccepted(false);
            } else {
                bucket.setCount(bucket.getCount() + increment);
                bucket.setLast(System.currentTimeMillis());
                response.setAccepted(bucket.getCount() <= limit);
            }
            int reset = (int)(bucket.getResetMillis(period) / 1000L);
            response.setReset(reset);
            response.setRemaining(limit - bucket.getCount());
            handler.handle((RateLimitResponse)((Object)AsyncResultImpl.create(response)));
        }
    }
}

