/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.i18n.Messages;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryRegistry
implements IRegistry {
    private Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishService(Service service, IAsyncResultHandler<Void> handler) {
        PublishingException error = null;
        Object object = this.mutex;
        synchronized (object) {
            String serviceKey = this.getServiceKey(service);
            if (this.getMap().containsKey(serviceKey)) {
                error = new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceAlreadyPublished", new Object[0]));
            } else {
                this.getMap().put(serviceKey, service);
            }
        }
        if (error == null) {
            handler.handle((Void)((Object)AsyncResultImpl.create((Void)null)));
        } else {
            handler.handle((Void)((Object)AsyncResultImpl.create((Throwable)error, Void.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retireService(Service service, IAsyncResultHandler<Void> handler) {
        PublishingException error = null;
        Object object = this.mutex;
        synchronized (object) {
            String serviceKey = this.getServiceKey(service);
            if (this.getMap().containsKey(serviceKey)) {
                this.getMap().remove(serviceKey);
            } else {
                error = new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceNotFound", new Object[0]));
            }
        }
        if (error == null) {
            handler.handle((Void)((Object)AsyncResultImpl.create((Void)null)));
        } else {
            handler.handle((Void)((Object)AsyncResultImpl.create((Throwable)error, Void.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerApplication(Application application, IAsyncResultHandler<Void> handler) {
        RegistrationException error = null;
        Object object = this.mutex;
        synchronized (object) {
            String svcKey;
            for (Contract contract : application.getContracts()) {
                String contractKey = this.getContractKey(contract);
                if (this.getMap().containsKey(contractKey)) {
                    error = new RegistrationException(Messages.i18n.format("InMemoryRegistry.ContractAlreadyPublished", new Object[]{contract.getApiKey()}));
                    break;
                }
                svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
                if (this.getMap().containsKey(svcKey)) continue;
                error = new RegistrationException(Messages.i18n.format("InMemoryRegistry.ServiceNotFoundInOrg", new Object[]{contract.getServiceId(), contract.getServiceOrgId()}));
                break;
            }
            String applicationKey = this.getApplicationKey(application);
            if (this.getMap().containsKey(applicationKey)) {
                error = new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppAlreadyRegistered", new Object[0]));
            } else {
                this.getMap().put(applicationKey, application);
                for (Contract contract : application.getContracts()) {
                    svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
                    Service service = (Service)this.getMap().get(svcKey);
                    ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPlan(), contract.getPolicies());
                    String contractKey = this.getContractKey(contract);
                    this.getMap().put(contractKey, sc);
                }
            }
        }
        if (error == null) {
            handler.handle((Void)((Object)AsyncResultImpl.create((Void)null)));
        } else {
            handler.handle((Void)((Object)AsyncResultImpl.create((Throwable)error, Void.class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterApplication(Application application, IAsyncResultHandler<Void> handler) {
        RegistrationException error = null;
        Object object = this.mutex;
        synchronized (object) {
            String applicationKey = this.getApplicationKey(application);
            if (this.getMap().containsKey(applicationKey)) {
                Application removed = (Application)this.getMap().remove(applicationKey);
                for (Contract contract : removed.getContracts()) {
                    String contractKey = this.getContractKey(contract);
                    if (!this.getMap().containsKey(contractKey)) continue;
                    this.getMap().remove(contractKey);
                }
            } else {
                error = new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppNotFound", new Object[0]));
            }
        }
        if (error == null) {
            handler.handle((Void)((Object)AsyncResultImpl.create((Void)null)));
        } else {
            handler.handle((Void)((Object)AsyncResultImpl.create((Throwable)error, Void.class)));
        }
    }

    @Override
    public void getContract(ServiceRequest request, IAsyncResultHandler<ServiceContract> handler) {
        String contractKey = this.getContractKey(request);
        ServiceContract contract = (ServiceContract)this.getMap().get(contractKey);
        if (contract == null) {
            InvalidContractException error = new InvalidContractException(Messages.i18n.format("InMemoryRegistry.NoContractForAPIKey", new Object[]{request.getApiKey()}));
            handler.handle((ServiceContract)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
            return;
        }
        Service service = contract.getService();
        String serviceKey = this.getServiceKey(service);
        if (this.getMap().get(serviceKey) == null) {
            InvalidContractException error = new InvalidContractException(Messages.i18n.format("InMemoryRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
            handler.handle((ServiceContract)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
            return;
        }
        handler.handle((ServiceContract)AsyncResultImpl.create(contract));
    }

    @Override
    public void getService(String organizationId, String serviceId, String serviceVersion, IAsyncResultHandler<Service> handler) {
        String key = this.getServiceKey(organizationId, serviceId, serviceVersion);
        Service service = (Service)this.getMap().get(key);
        handler.handle((Service)AsyncResultImpl.create(service));
    }

    private String getServiceKey(Service service) {
        return this.getServiceKey(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceKey(String orgId, String serviceId, String version) {
        return "SVC::" + orgId + "|" + serviceId + "|" + version;
    }

    private String getApplicationKey(Application app) {
        return "APP::" + app.getOrganizationId() + "|" + app.getApplicationId() + "|" + app.getVersion();
    }

    private String getContractKey(ServiceRequest request) {
        return "CONTRACT::" + request.getApiKey();
    }

    private String getContractKey(Contract contract) {
        return "CONTRACT::" + contract.getApiKey();
    }

    protected Map<String, Object> getMap() {
        return this.map;
    }
}

