/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.IServiceConnector;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.auth.RequiredAuthType;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.InvalidServiceException;
import io.apiman.gateway.engine.beans.exceptions.RequestAbortedException;
import io.apiman.gateway.engine.i18n.Messages;
import io.apiman.gateway.engine.impl.EngineResultImpl;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.engine.metrics.RequestMetric;
import io.apiman.gateway.engine.policy.Chain;
import io.apiman.gateway.engine.policy.IConnectorInterceptor;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import io.apiman.gateway.engine.policy.RequestChain;
import io.apiman.gateway.engine.policy.ResponseChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class ServiceRequestExecutorImpl
implements IServiceRequestExecutor {
    private IRegistry registry;
    private ServiceRequest request;
    private Service service;
    private IPolicyContext context;
    private List<Policy> policies;
    private IPolicyFactory policyFactory;
    private IConnectorFactory connectorFactory;
    private boolean finished = false;
    private List<PolicyWithConfiguration> policyImpls;
    private IAsyncResultHandler<IEngineResult> resultHandler;
    private IAsyncHandler<PolicyFailure> policyFailureHandler;
    private IAsyncHandler<Throwable> policyErrorHandler;
    private IAsyncHandler<ISignalWriteStream> inboundStreamHandler;
    private Chain<ServiceRequest> requestChain;
    private Chain<ServiceResponse> responseChain;
    private IServiceConnection serviceConnection;
    private IServiceConnectionResponse serviceConnectionResponse;
    private IMetrics metrics;
    private RequestMetric requestMetric = new RequestMetric();

    public ServiceRequestExecutorImpl(ServiceRequest serviceRequest, IAsyncResultHandler<IEngineResult> resultHandler, IRegistry registry, IPolicyContext context, IPolicyFactory policyFactory, IConnectorFactory connectorFactory, IMetrics metrics) {
        this.request = serviceRequest;
        this.registry = registry;
        this.resultHandler = this.wrapResultHandler(resultHandler);
        this.context = context;
        this.policyFactory = policyFactory;
        this.connectorFactory = connectorFactory;
        this.policyFailureHandler = this.createPolicyFailureHandler();
        this.policyErrorHandler = this.createPolicyErrorHandler();
        this.metrics = metrics;
    }

    private IAsyncResultHandler<IEngineResult> wrapResultHandler(final IAsyncResultHandler<IEngineResult> handler) {
        return new IAsyncResultHandler<IEngineResult>(){

            @Override
            public void handle(IAsyncResult<IEngineResult> result) {
                if (result.isError()) {
                    ServiceRequestExecutorImpl.this.recordErrorMetrics(result.getError());
                } else {
                    IEngineResult engineResult = result.getResult();
                    if (engineResult.isFailure()) {
                        ServiceRequestExecutorImpl.this.recordFailureMetrics(engineResult.getPolicyFailure());
                    } else {
                        ServiceRequestExecutorImpl.this.recordSuccessMetrics(engineResult.getServiceResponse());
                    }
                }
                ServiceRequestExecutorImpl.this.requestMetric.setRequestEnd(new Date());
                ServiceRequestExecutorImpl.this.metrics.record(ServiceRequestExecutorImpl.this.requestMetric);
                handler.handle(result);
            }
        };
    }

    protected void recordSuccessMetrics(ServiceResponse response) {
        this.requestMetric.setResponseCode(response.getCode());
        this.requestMetric.setResponseMessage(response.getMessage());
    }

    protected void recordFailureMetrics(PolicyFailure failure) {
        this.requestMetric.setResponseCode(failure.getResponseCode());
        this.requestMetric.setFailure(true);
        this.requestMetric.setFailureCode(failure.getFailureCode());
        this.requestMetric.setFailureReason(failure.getMessage());
    }

    protected void recordErrorMetrics(Throwable error) {
        this.requestMetric.setResponseCode(500);
        this.requestMetric.setError(true);
        this.requestMetric.setErrorMessage(error.getMessage());
    }

    @Override
    public void execute() {
        this.requestMetric.setRequestStart(new Date());
        this.requestMetric.setResource(this.request.getDestination());
        this.requestMetric.setMethod(this.request.getType());
        this.requestMetric.setServiceOrgId(this.request.getServiceOrgId());
        this.requestMetric.setServiceId(this.request.getServiceId());
        this.requestMetric.setServiceVersion(this.request.getServiceVersion());
        this.context.setAttribute("apiman.request-metric", this.requestMetric);
        final IAsyncHandler<List<PolicyWithConfiguration>> policiesLoadedHandler = new IAsyncHandler<List<PolicyWithConfiguration>>(){

            @Override
            public void handle(List<PolicyWithConfiguration> result) {
                ServiceRequestExecutorImpl.this.policyImpls = result;
                ServiceRequestExecutorImpl.this.requestChain = ServiceRequestExecutorImpl.this.createRequestChain(new IAsyncHandler<ServiceRequest>(){

                    @Override
                    public void handle(ServiceRequest request) {
                        IConnectorInterceptor connectorInterceptor = ServiceRequestExecutorImpl.this.context.getConnectorInterceptor();
                        IServiceConnector connector = null;
                        connector = connectorInterceptor == null ? ServiceRequestExecutorImpl.this.connectorFactory.createConnector(request, ServiceRequestExecutorImpl.this.service, RequiredAuthType.parseType(ServiceRequestExecutorImpl.this.service)) : connectorInterceptor.createConnector();
                        ServiceRequestExecutorImpl.this.requestMetric.setServiceStart(new Date());
                        ServiceRequestExecutorImpl.this.serviceConnection = connector.connect(request, ServiceRequestExecutorImpl.this.createServiceConnectionResponseHandler());
                        ServiceRequestExecutorImpl.this.requestChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                            @Override
                            public void handle(IApimanBuffer buffer) {
                                ServiceRequestExecutorImpl.this.serviceConnection.write(buffer);
                            }
                        });
                        ServiceRequestExecutorImpl.this.requestChain.endHandler(new IAsyncHandler<Void>(){

                            @Override
                            public void handle(Void result) {
                                ServiceRequestExecutorImpl.this.serviceConnection.end();
                            }
                        });
                        ServiceRequestExecutorImpl.this.handleStream();
                    }
                });
                ServiceRequestExecutorImpl.this.requestChain.policyFailureHandler(ServiceRequestExecutorImpl.this.policyFailureHandler);
                ServiceRequestExecutorImpl.this.requestChain.doApply(ServiceRequestExecutorImpl.this.request);
            }
        };
        if (this.request.getApiKey() == null) {
            this.registry.getService(this.request.getServiceOrgId(), this.request.getServiceId(), this.request.getServiceVersion(), new IAsyncResultHandler<Service>(){

                @Override
                public void handle(IAsyncResult<Service> result) {
                    if (result.isSuccess()) {
                        ServiceRequestExecutorImpl.this.service = result.getResult();
                        if (ServiceRequestExecutorImpl.this.service == null) {
                            InvalidServiceException error = new InvalidServiceException(Messages.i18n.format("EngineImpl.ServiceNotFound", new Object[0]));
                            ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create((Throwable)error, IEngineResult.class));
                        } else if (!ServiceRequestExecutorImpl.this.service.isPublicService()) {
                            InvalidServiceException error = new InvalidServiceException(Messages.i18n.format("EngineImpl.ServiceNotPublic", new Object[0]));
                            ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create((Throwable)error, IEngineResult.class));
                        } else {
                            ServiceRequestExecutorImpl.this.request.setService(ServiceRequestExecutorImpl.this.service);
                            ServiceRequestExecutorImpl.this.policies = ServiceRequestExecutorImpl.this.service.getServicePolicies();
                            ServiceRequestExecutorImpl.this.policyImpls = new ArrayList(ServiceRequestExecutorImpl.this.policies.size());
                            ServiceRequestExecutorImpl.this.loadPolicies(policiesLoadedHandler);
                        }
                    } else if (result.isError()) {
                        ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(result.getError(), IEngineResult.class));
                    }
                }
            });
        } else {
            this.registry.getContract(this.request, new IAsyncResultHandler<ServiceContract>(){

                @Override
                public void handle(IAsyncResult<ServiceContract> result) {
                    if (result.isSuccess()) {
                        ServiceContract serviceContract = result.getResult();
                        ServiceRequestExecutorImpl.this.requestMetric.setApplicationOrgId(serviceContract.getApplication().getOrganizationId());
                        ServiceRequestExecutorImpl.this.requestMetric.setApplicationId(serviceContract.getApplication().getApplicationId());
                        ServiceRequestExecutorImpl.this.requestMetric.setApplicationVersion(serviceContract.getApplication().getVersion());
                        ServiceRequestExecutorImpl.this.requestMetric.setPlanId(serviceContract.getPlan());
                        ServiceRequestExecutorImpl.this.requestMetric.setContractId(ServiceRequestExecutorImpl.this.request.getApiKey());
                        ServiceRequestExecutorImpl.this.service = serviceContract.getService();
                        ServiceRequestExecutorImpl.this.request.setContract(serviceContract);
                        ServiceRequestExecutorImpl.this.request.setService(ServiceRequestExecutorImpl.this.service);
                        ServiceRequestExecutorImpl.this.policies = serviceContract.getPolicies();
                        ServiceRequestExecutorImpl.this.policyImpls = new ArrayList(ServiceRequestExecutorImpl.this.policies.size());
                        if (ServiceRequestExecutorImpl.this.request.getServiceOrgId() != null) {
                            try {
                                ServiceRequestExecutorImpl.this.validateRequest(ServiceRequestExecutorImpl.this.request);
                            }
                            catch (InvalidContractException e) {
                                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(e, IEngineResult.class));
                                return;
                            }
                        }
                        ServiceRequestExecutorImpl.this.loadPolicies(policiesLoadedHandler);
                    } else {
                        ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(result.getError(), IEngineResult.class));
                    }
                }
            });
        }
    }

    protected void validateRequest(ServiceRequest request) throws InvalidContractException {
        ServiceContract contract = request.getContract();
        boolean matches = true;
        if (!contract.getService().getOrganizationId().equals(request.getServiceOrgId())) {
            matches = false;
        }
        if (!contract.getService().getServiceId().equals(request.getServiceId())) {
            matches = false;
        }
        if (!contract.getService().getVersion().equals(request.getServiceVersion())) {
            matches = false;
        }
        if (!matches) {
            throw new InvalidContractException(Messages.i18n.format("EngineImpl.InvalidContractForService", new Object[]{request.getServiceOrgId(), request.getServiceId(), request.getServiceVersion()}));
        }
    }

    private void loadPolicies(final IAsyncHandler<List<PolicyWithConfiguration>> handler) {
        final HashSet totalCounter = new HashSet();
        final TreeSet errorCounter = new TreeSet();
        final ArrayList<Object> rval = new ArrayList<Object>(this.policies.size());
        final ArrayList<Object> errors = new ArrayList<Object>(this.policies.size());
        final int numPolicies = this.policies.size();
        int index = 0;
        if (this.policies.isEmpty()) {
            handler.handle(this.policyImpls);
            return;
        }
        for (final Policy policy : this.policies) {
            rval.add(null);
            errors.add(null);
            final int localIdx = index++;
            this.policyFactory.loadPolicy(policy.getPolicyImpl(), new IAsyncResultHandler<IPolicy>(){

                @Override
                public void handle(IAsyncResult<IPolicy> result) {
                    if (result.isSuccess()) {
                        IPolicy policyImpl = result.getResult();
                        try {
                            Object policyConfig = ServiceRequestExecutorImpl.this.policyFactory.loadConfig(policyImpl, policy.getPolicyImpl(), policy.getPolicyJsonConfig());
                            PolicyWithConfiguration pwc = new PolicyWithConfiguration(policyImpl, policyConfig);
                            rval.set(localIdx, pwc);
                        }
                        catch (Throwable t) {
                            errors.set(localIdx, t);
                            errorCounter.add(localIdx);
                        }
                    } else {
                        Throwable error = result.getError();
                        errors.set(localIdx, error);
                        errorCounter.add(localIdx);
                    }
                    totalCounter.add(localIdx);
                    if (totalCounter.size() == numPolicies) {
                        if (errorCounter.size() > 0) {
                            int errorIdx = (Integer)errorCounter.iterator().next();
                            Throwable error = (Throwable)errors.get(errorIdx);
                            ServiceRequestExecutorImpl.this.policyErrorHandler.handle(error);
                        } else {
                            handler.handle(rval);
                        }
                    }
                }
            });
        }
    }

    private IAsyncResultHandler<IServiceConnectionResponse> createServiceConnectionResponseHandler() {
        return new IAsyncResultHandler<IServiceConnectionResponse>(){

            @Override
            public void handle(IAsyncResult<IServiceConnectionResponse> result) {
                if (result.isSuccess()) {
                    ServiceRequestExecutorImpl.this.requestMetric.setServiceEnd(new Date());
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse = result.getResult();
                    ServiceResponse serviceResponse = (ServiceResponse)ServiceRequestExecutorImpl.this.serviceConnectionResponse.getHead();
                    ServiceRequestExecutorImpl.this.context.setAttribute("apiman.engine.serviceResponse", serviceResponse);
                    ServiceRequestExecutorImpl.this.responseChain = ServiceRequestExecutorImpl.this.createResponseChain(new IAsyncHandler<ServiceResponse>(){

                        @Override
                        public void handle(ServiceResponse result) {
                            final EngineResultImpl engineResult = new EngineResultImpl(result);
                            engineResult.setConnectorResponseStream(ServiceRequestExecutorImpl.this.serviceConnectionResponse);
                            ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
                            ServiceRequestExecutorImpl.this.responseChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                                @Override
                                public void handle(IApimanBuffer result) {
                                    engineResult.write(result);
                                }
                            });
                            ServiceRequestExecutorImpl.this.responseChain.endHandler(new IAsyncHandler<Void>(){

                                @Override
                                public void handle(Void result) {
                                    engineResult.end();
                                    ServiceRequestExecutorImpl.this.finished = true;
                                }
                            });
                            ServiceRequestExecutorImpl.this.serviceConnectionResponse.transmit();
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                        @Override
                        public void handle(IApimanBuffer buffer) {
                            ServiceRequestExecutorImpl.this.responseChain.write(buffer);
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.endHandler(new IAsyncHandler<Void>(){

                        @Override
                        public void handle(Void result) {
                            ServiceRequestExecutorImpl.this.responseChain.end();
                        }
                    });
                    ServiceRequestExecutorImpl.this.responseChain.doApply(serviceResponse);
                }
            }
        };
    }

    protected void handleStream() {
        this.inboundStreamHandler.handle(new ISignalWriteStream(){
            boolean streamFinished = false;

            @Override
            public void write(IApimanBuffer buffer) {
                if (this.streamFinished) {
                    throw new IllegalStateException("Attempted write after #end() was called.");
                }
                ServiceRequestExecutorImpl.this.requestChain.write(buffer);
            }

            @Override
            public void end() {
                ServiceRequestExecutorImpl.this.requestChain.end();
                this.streamFinished = true;
            }

            @Override
            public void abort() {
                this.streamFinished = true;
                ServiceRequestExecutorImpl.this.serviceConnection.abort();
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create((Throwable)new RequestAbortedException()));
            }

            @Override
            public boolean isFinished() {
                return this.streamFinished;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void streamHandler(IAsyncHandler<ISignalWriteStream> handler) {
        this.inboundStreamHandler = handler;
    }

    private Chain<ServiceRequest> createRequestChain(IAsyncHandler<ServiceRequest> requestHandler) {
        RequestChain requestChain = new RequestChain(this.policyImpls, this.context);
        requestChain.headHandler(requestHandler);
        requestChain.policyFailureHandler(this.policyFailureHandler);
        requestChain.policyErrorHandler(this.policyErrorHandler);
        return requestChain;
    }

    private Chain<ServiceResponse> createResponseChain(IAsyncHandler<ServiceResponse> responseHandler) {
        ResponseChain responseChain = new ResponseChain(this.policyImpls, this.context);
        responseChain.headHandler(responseHandler);
        responseChain.policyFailureHandler(new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyFailureHandler.handle(result);
            }
        });
        responseChain.policyErrorHandler(new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyErrorHandler.handle(result);
            }
        });
        return responseChain;
    }

    private IAsyncHandler<PolicyFailure> createPolicyFailureHandler() {
        return new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                EngineResultImpl engineResult = new EngineResultImpl(result);
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
            }
        };
    }

    private IAsyncHandler<Throwable> createPolicyErrorHandler() {
        return new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable error) {
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(error));
            }
        };
    }
}

