/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.DependsOnComponents;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalReadStream;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@DependsOnComponents(value={IBufferFactoryComponent.class})
public class InMemoryCacheStoreComponent
implements ICacheStoreComponent {
    private Object mapMutex = new Object();
    private Object cacheSizeMutex = new Object();
    private Map<String, Long> expireOnMap = new HashMap<String, Long>();
    private Map<String, Object> objectCache = new LinkedHashMap<String, Object>();
    private Map<String, IApimanBuffer> dataCache = new HashMap<String, IApimanBuffer>();
    private long cacheSize = 0L;
    private long maxCacheSize = 0xA00000L;
    private IBufferFactoryComponent bufferFactory;

    public InMemoryCacheStoreComponent() {
    }

    public InMemoryCacheStoreComponent(Map<String, String> config) {
        String mcs = config.get("maxCacheSize");
        if (mcs != null) {
            this.maxCacheSize = new Long(mcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(String cacheKey, T jsonObject, long timeToLive) throws IOException {
        Object object = this.mapMutex;
        synchronized (object) {
            this.expireOnMap.put(cacheKey, System.currentTimeMillis() + timeToLive * 1000L);
            this.objectCache.put(cacheKey, jsonObject);
            this.dataCache.put(cacheKey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ISignalWriteStream putBinary(String cacheKey, T jsonObject, long timeToLive) throws IOException {
        final IApimanBuffer buffer = this.bufferFactory.createBuffer();
        Object object = this.mapMutex;
        synchronized (object) {
            this.expireOnMap.put(cacheKey, System.currentTimeMillis() + timeToLive * 1000L);
            this.objectCache.put(cacheKey, jsonObject);
            this.dataCache.put(cacheKey, buffer);
        }
        return new ISignalWriteStream(){
            private boolean finished = false;

            @Override
            public void abort() {
                this.finished = true;
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }

            @Override
            public void write(IApimanBuffer chunk) {
                buffer.append(chunk);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void end() {
                this.finished = true;
                Object object = InMemoryCacheStoreComponent.this.cacheSizeMutex;
                synchronized (object) {
                    InMemoryCacheStoreComponent.this.cacheSize += buffer.length();
                    if (InMemoryCacheStoreComponent.this.cacheSize > InMemoryCacheStoreComponent.this.maxCacheSize) {
                        Object object2 = InMemoryCacheStoreComponent.this.mapMutex;
                        synchronized (object2) {
                            while (InMemoryCacheStoreComponent.this.cacheSize > InMemoryCacheStoreComponent.this.maxCacheSize) {
                                String cacheKey = (String)InMemoryCacheStoreComponent.this.objectCache.keySet().iterator().next();
                                InMemoryCacheStoreComponent.this.objectCache.remove(cacheKey);
                                InMemoryCacheStoreComponent.this.expireOnMap.remove(cacheKey);
                                IApimanBuffer removedBuffer = (IApimanBuffer)InMemoryCacheStoreComponent.this.dataCache.remove(cacheKey);
                                if (removedBuffer == null) continue;
                                InMemoryCacheStoreComponent.this.cacheSize -= removedBuffer.length();
                            }
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void get(String cacheKey, Class<T> type, IAsyncResultHandler<T> handler) {
        boolean expired = false;
        Object rval = null;
        Object object = this.mapMutex;
        synchronized (object) {
            Long expiresOn;
            rval = this.objectCache.get(cacheKey);
            if (rval != null && (expiresOn = this.expireOnMap.get(cacheKey)) > System.currentTimeMillis()) {
                expired = true;
            }
        }
        if (expired) {
            object = this.cacheSizeMutex;
            synchronized (object) {
                Object object2 = this.mapMutex;
                synchronized (object2) {
                    this.objectCache.remove(cacheKey);
                    this.expireOnMap.remove(cacheKey);
                    IApimanBuffer buffer = this.dataCache.remove(cacheKey);
                    if (buffer != null) {
                        this.cacheSize -= (long)buffer.length();
                    }
                }
            }
            rval = null;
        }
        handler.handle(AsyncResultImpl.create(rval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void getBinary(String cacheKey, Class<T> type, IAsyncResultHandler<ISignalReadStream<T>> handler) {
        ISignalReadStream rval;
        Object expiresOn;
        boolean expired = false;
        Object object = null;
        IApimanBuffer buffer = null;
        Object object2 = this.mapMutex;
        synchronized (object2) {
            object = this.objectCache.get(cacheKey);
            if (object != null) {
                expiresOn = this.expireOnMap.get(cacheKey);
                if (System.currentTimeMillis() > (Long)expiresOn) {
                    expired = true;
                }
            }
            if ((buffer = this.dataCache.get(cacheKey)) == null) {
                object = null;
            }
        }
        if (object == null) {
            rval = null;
        } else if (expired) {
            object2 = this.cacheSizeMutex;
            synchronized (object2) {
                expiresOn = this.mapMutex;
                synchronized (expiresOn) {
                    this.objectCache.remove(cacheKey);
                    this.expireOnMap.remove(cacheKey);
                    this.dataCache.remove(cacheKey);
                    if (buffer != null) {
                        this.cacheSize -= (long)buffer.length();
                    }
                }
            }
            rval = null;
        } else {
            final Object head = object;
            final IApimanBuffer data = buffer;
            rval = new ISignalReadStream<T>(){
                IAsyncHandler<IApimanBuffer> bodyHandler;
                IAsyncHandler<Void> endHandler;
                boolean finished = false;

                @Override
                public void bodyHandler(IAsyncHandler<IApimanBuffer> bodyHandler) {
                    this.bodyHandler = bodyHandler;
                }

                @Override
                public void endHandler(IAsyncHandler<Void> endHandler) {
                    this.endHandler = endHandler;
                }

                @Override
                public T getHead() {
                    return head;
                }

                @Override
                public boolean isFinished() {
                    return this.finished;
                }

                @Override
                public void abort() {
                    this.finished = true;
                }

                @Override
                public void transmit() {
                    this.bodyHandler.handle(data);
                    this.endHandler.handle(null);
                }
            };
        }
        handler.handle((ISignalReadStream<AsyncResultImpl<Object>>)((Object)AsyncResultImpl.create(rval)));
    }

    public void setBufferFactory(IBufferFactoryComponent bufferFactory) {
        this.bufferFactory = bufferFactory;
    }
}

