/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.auth;

import io.apiman.gateway.engine.beans.Service;
import java.util.HashMap;
import java.util.Map;

public enum RequiredAuthType {
    MTLS("mtls", "mssl"),
    BASIC("basic"),
    DEFAULT("none");

    public static final String ENDPOINT_AUTHORIZATION_TYPE = "authorization.type";
    private static Map<String, RequiredAuthType> constants;
    private final String[] aliases;

    private RequiredAuthType(String ... aliases) {
        this.aliases = aliases;
    }

    public static RequiredAuthType fromValue(String value) {
        if (value == null) {
            return DEFAULT;
        }
        RequiredAuthType constant = constants.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static RequiredAuthType parseType(Service service) {
        return RequiredAuthType.fromValue((String)service.getEndpointProperties().get(ENDPOINT_AUTHORIZATION_TYPE));
    }

    static {
        constants = new HashMap<String, RequiredAuthType>();
        for (RequiredAuthType authType : RequiredAuthType.values()) {
            for (String alias : authType.aliases) {
                constants.put(alias.toLowerCase(), authType);
            }
        }
    }
}

