/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineFactory;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.impl.EngineImpl;
import io.apiman.gateway.engine.policy.IPolicyFactory;

public abstract class AbstractEngineFactory
implements IEngineFactory {
    @Override
    public final IEngine createEngine() {
        IPluginRegistry pluginRegistry = this.createPluginRegistry();
        IRegistry registry = this.createRegistry(pluginRegistry);
        IComponentRegistry componentRegistry = this.createComponentRegistry(pluginRegistry);
        IConnectorFactory cfactory = this.createConnectorFactory(pluginRegistry);
        IPolicyFactory pfactory = this.createPolicyFactory(pluginRegistry);
        IMetrics metrics = this.createMetrics(pluginRegistry);
        EngineImpl engine = new EngineImpl(registry, pluginRegistry, componentRegistry, cfactory, pfactory, metrics);
        return engine;
    }

    protected abstract IPluginRegistry createPluginRegistry();

    protected abstract IRegistry createRegistry(IPluginRegistry var1);

    protected abstract IComponentRegistry createComponentRegistry(IPluginRegistry var1);

    protected abstract IConnectorFactory createConnectorFactory(IPluginRegistry var1);

    protected abstract IPolicyFactory createPolicyFactory(IPluginRegistry var1);

    protected abstract IMetrics createMetrics(IPluginRegistry var1);
}

