/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.common.util.ReflectionUtils;
import io.apiman.gateway.engine.DependsOnComponents;
import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IRequiresInitialization;
import io.apiman.gateway.engine.beans.exceptions.ComponentNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConfigDrivenComponentRegistry
implements IComponentRegistry {
    private IEngineConfig engineConfig;
    private IPluginRegistry pluginRegistry;
    private Map<Class<? extends IComponent>, IComponent> components = new HashMap<Class<? extends IComponent>, IComponent>();

    public ConfigDrivenComponentRegistry(IEngineConfig engineConfig, IPluginRegistry pluginRegistry) {
        this.engineConfig = engineConfig;
        this.pluginRegistry = pluginRegistry;
    }

    @Override
    public Collection<IComponent> getComponents() {
        return this.components.values();
    }

    @Override
    public <T extends IComponent> T getComponent(Class<T> componentType) throws ComponentNotFoundException {
        if (this.components.containsKey(componentType)) {
            return (T)this.components.get(componentType);
        }
        return this.createAndRegisterComponent(componentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IComponent> T createAndRegisterComponent(Class<T> componentType) throws ComponentNotFoundException {
        try {
            Map<Class<? extends IComponent>, IComponent> map = this.components;
            synchronized (map) {
                Class<T> componentClass = this.engineConfig.getComponentClass(componentType, this.pluginRegistry);
                Map<String, String> componentConfig = this.engineConfig.getComponentConfig(componentType);
                IComponent component = (IComponent)this.create(componentClass, componentConfig);
                this.components.put(componentType, component);
                DependsOnComponents annotation = componentClass.getAnnotation(DependsOnComponents.class);
                if (annotation != null) {
                    Class<? extends IComponent>[] value;
                    for (Class<? extends IComponent> theC : value = annotation.value()) {
                        Method setter = ReflectionUtils.findSetter(componentClass, theC);
                        if (setter == null) continue;
                        IComponent injectedComponent = this.getComponent(theC);
                        try {
                            setter.invoke((Object)component, injectedComponent);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (component instanceof IRequiresInitialization) {
                    ((IRequiresInitialization)((Object)component)).initialize();
                }
                return (T)component;
            }
        }
        catch (Exception e) {
            throw new ComponentNotFoundException(componentType.getName());
        }
    }

    protected void addComponentMapping(Class<? extends IComponent> klazz, IComponent component) {
        this.components.put(klazz, component);
    }

    protected <T> T create(Class<T> type, Map<String, String> config) {
        try {
            Constructor<T> constructor = type.getConstructor(Map.class);
            return constructor.newInstance(config);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

