/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.common.util.AesEncrypter;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import java.util.List;
import java.util.Set;

public class SecureRegistryWrapper
implements IRegistry {
    private final IRegistry delegate;

    public SecureRegistryWrapper(IRegistry delegate) {
        this.delegate = delegate;
    }

    @Override
    public void publishService(Service service, IAsyncResultHandler<Void> handler) {
        List policies = service.getServicePolicies();
        this.encryptPolicies(policies);
        this.delegate.publishService(service, handler);
    }

    @Override
    public void registerApplication(Application application, IAsyncResultHandler<Void> handler) {
        Set contracts = application.getContracts();
        if (contracts != null) {
            for (Contract contract : contracts) {
                List policies = contract.getPolicies();
                this.encryptPolicies(policies);
            }
        }
        this.delegate.registerApplication(application, handler);
    }

    @Override
    public void retireService(Service service, IAsyncResultHandler<Void> handler) {
        this.delegate.retireService(service, handler);
    }

    @Override
    public void unregisterApplication(Application application, IAsyncResultHandler<Void> handler) {
        this.delegate.unregisterApplication(application, handler);
    }

    @Override
    public void getService(String organizationId, String serviceId, String serviceVersion, final IAsyncResultHandler<Service> handler) {
        this.delegate.getService(organizationId, serviceId, serviceVersion, new IAsyncResultHandler<Service>(){

            @Override
            public void handle(IAsyncResult<Service> result) {
                Service service;
                if (result.isSuccess() && (service = result.getResult()) != null) {
                    List policies = service.getServicePolicies();
                    SecureRegistryWrapper.this.decryptPolicies(policies);
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void getContract(ServiceRequest request, final IAsyncResultHandler<ServiceContract> handler) {
        this.delegate.getContract(request, new IAsyncResultHandler<ServiceContract>(){

            @Override
            public void handle(IAsyncResult<ServiceContract> result) {
                if (result.isSuccess()) {
                    ServiceContract contract = result.getResult();
                    List policies = contract.getPolicies();
                    SecureRegistryWrapper.this.decryptPolicies(policies);
                }
                handler.handle(result);
            }
        });
    }

    protected void encryptPolicies(List<Policy> policies) {
        if (policies != null) {
            for (Policy policy : policies) {
                String jsonConfig = policy.getPolicyJsonConfig();
                policy.setPolicyJsonConfig(AesEncrypter.encrypt((String)jsonConfig));
            }
        }
    }

    protected void decryptPolicies(List<Policy> policies) {
        if (policies != null) {
            for (Policy policy : policies) {
                String encryptedConfig = policy.getPolicyJsonConfig();
                policy.setPolicyJsonConfig(AesEncrypter.decrypt((String)encryptedConfig));
            }
        }
    }
}

