/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.es.ESClientFactory;
import io.apiman.gateway.engine.es.ESUtils;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;

public class ESRateLimiterComponent
implements IRateLimiterComponent {
    private Map<String, String> config;
    private Client esClient;

    public ESRateLimiterComponent(Map<String, String> config) {
        this.config = config;
    }

    public void accept(final String bucketId, final RateBucketPeriod period, final int limit, final IAsyncResultHandler<RateLimitResponse> handler) {
        final String id = this.id(bucketId);
        this.getClient().prepareGet("apiman_gateway", "rateBucket", id).setFetchSource(true).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                long version;
                RateLimiterBucket bucket = null;
                if (response.isExists()) {
                    version = response.getVersion();
                    bucket = ESRateLimiterComponent.this.readBucket(response);
                } else {
                    version = 0L;
                    bucket = new RateLimiterBucket();
                }
                bucket.resetIfNecessary(period);
                RateLimitResponse rlr = new RateLimitResponse();
                if (bucket.count >= limit) {
                    rlr.setAccepted(false);
                } else {
                    ++bucket.count;
                    bucket.last = System.currentTimeMillis();
                    rlr.setAccepted(true);
                }
                int reset = (int)(bucket.getResetMillis(period) / 1000L);
                rlr.setReset((long)reset);
                rlr.setRemaining(limit - bucket.count);
                ESRateLimiterComponent.this.updateBucketAndReturn(id, bucket, rlr, version, bucketId, period, limit, (IAsyncResultHandler<RateLimitResponse>)handler);
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e, RateLimitResponse.class));
            }
        });
    }

    protected RateLimiterBucket readBucket(GetResponse response) {
        RateLimiterBucket bucket = new RateLimiterBucket();
        Map source = response.getSourceAsMap();
        bucket.count = ((Number)source.get("count")).intValue();
        bucket.last = ((Number)source.get("last")).longValue();
        return bucket;
    }

    protected void updateBucketAndReturn(String id, RateLimiterBucket bucket, final RateLimitResponse rlr, long version, final String bucketId, final RateBucketPeriod period, final int limit, final IAsyncResultHandler<RateLimitResponse> handler) {
        HashMap<String, Number> source = new HashMap<String, Number>();
        source.put("count", bucket.count);
        source.put("last", bucket.last);
        this.getClient().prepareIndex("apiman_gateway", "rateBucket", id).setVersion(version).setContentType(XContentType.JSON).setCreate(false).setSource(source).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                handler.handle((Object)AsyncResultImpl.create((Object)rlr));
            }

            public void onFailure(Throwable e) {
                if (ESUtils.rootCause(e) instanceof VersionConflictEngineException) {
                    ESRateLimiterComponent.this.accept(bucketId, period, limit, (IAsyncResultHandler<RateLimitResponse>)handler);
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                }
            }
        });
    }

    private String id(String bucketId) {
        return Base64.encodeBytes((byte[])bucketId.getBytes());
    }

    public synchronized Client getClient() {
        if (this.esClient == null) {
            this.esClient = ESClientFactory.createClient(this.config);
        }
        return this.esClient;
    }
}

