/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.es.ESClientFactory;
import io.apiman.gateway.engine.es.ESRegistryMarshalling;
import io.apiman.gateway.engine.es.ESUtils;
import io.apiman.gateway.engine.es.i18n.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ESRegistry
implements IRegistry {
    private Map<String, String> config;
    private Client esClient;

    public ESRegistry(Map<String, String> config) {
        this.config = config;
    }

    public void publishService(Service service, final IAsyncResultHandler<Void> handler) {
        try {
            String id = this.getServiceId(service);
            this.getClient().prepareIndex("apiman_gateway", "service", id).setSource(ESRegistryMarshalling.marshall(service)).setCreate(true).setContentType(XContentType.JSON).execute((ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    if (!response.isCreated()) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceAlreadyPublished", new Object[0])), Void.class));
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Object)null));
                    }
                }

                public void onFailure(Throwable e) {
                    if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceAlreadyPublished", new Object[0])), Void.class));
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingService", new Object[0]), e), Void.class));
                    }
                }
            });
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingService", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void retireService(Service service, final IAsyncResultHandler<Void> handler) {
        String id = this.getServiceId(service);
        this.getClient().prepareDelete("apiman_gateway", "service", id).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (response.isFound()) {
                    handler.handle((Object)AsyncResultImpl.create((Object)null));
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceNotFound", new Object[0])), Void.class));
                }
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorRetiringService", new Object[0]), e), Void.class));
            }
        });
    }

    public void registerApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        final HashMap<String, Service> svcMap = new HashMap<String, Service>();
        this.validateApplication(application, svcMap, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    handler.handle(result);
                } else {
                    String id = ESRegistry.this.getApplicationId(application);
                    try {
                        ESRegistry.this.getClient().prepareIndex("apiman_gateway", "application", id).setSource(ESRegistryMarshalling.marshall(application)).setCreate(true).setContentType(XContentType.JSON).execute((ActionListener)new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse response) {
                                if (!response.isCreated()) {
                                    handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.AppAlreadyRegistered", new Object[0])), Void.class));
                                } else {
                                    Iterator iterator = application.getContracts().iterator();
                                    application.setContracts(null);
                                    ESRegistry.this.registerContracts(application, iterator, svcMap, (IAsyncResultHandler<Void>)handler);
                                }
                            }

                            public void onFailure(Throwable e) {
                                if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                                    handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.AppAlreadyRegistered", new Object[0])), Void.class));
                                } else {
                                    handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringApplication", new Object[0]), e), Void.class));
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringApplication", new Object[0]), (Throwable)e), Void.class));
                    }
                }
            }
        });
    }

    private void validateApplication(Application application, Map<String, Service> serviceMap, IAsyncResultHandler<Void> handler) {
        Set contracts = application.getContracts();
        if (contracts.isEmpty()) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.NoContracts", new Object[0])), Void.class));
            return;
        }
        Iterator<Contract> iterator = contracts.iterator();
        this.validateServiceExists(iterator, serviceMap, handler);
    }

    private void validateServiceExists(final Iterator<Contract> iterator, final Map<String, Service> serviceMap, final IAsyncResultHandler<Void> handler) {
        if (!iterator.hasNext()) {
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        } else {
            final Contract contract = iterator.next();
            final String serviceId = this.getServiceId(contract);
            this.getService(serviceId, new IAsyncResultHandler<Service>(){

                public void handle(IAsyncResult<Service> result) {
                    if (result.isError()) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorValidatingApp", new Object[0]), result.getError()), Void.class));
                    } else {
                        Service service = (Service)result.getResult();
                        if (service == null) {
                            String serviceId2 = contract.getServiceId();
                            String orgId = contract.getServiceOrgId();
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ServiceNotFoundInOrg", new Object[]{serviceId2, orgId})), Void.class));
                        } else {
                            service.setServicePolicies(null);
                            serviceMap.put(serviceId, service);
                            ESRegistry.this.validateServiceExists(iterator, serviceMap, (IAsyncResultHandler<Void>)handler);
                        }
                    }
                }
            });
        }
    }

    private void registerContracts(final Application application, final Iterator<Contract> contracts, final Map<String, Service> serviceMap, final IAsyncResultHandler<Void> handler) {
        try {
            if (!contracts.hasNext()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                Contract contract = contracts.next();
                String svcId = this.getServiceId(contract);
                Service service = serviceMap.get(svcId);
                ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPolicies());
                final String contractId = this.getContractId(contract);
                XContentBuilder source = ESRegistryMarshalling.marshall(sc);
                this.getClient().prepareIndex("apiman_gateway", "serviceContract", contractId).setSource(source).setCreate(true).setContentType(XContentType.JSON).execute((ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        if (!response.isCreated()) {
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ContractAlreadyPublished", new Object[]{contractId})), Void.class));
                        } else {
                            ESRegistry.this.registerContracts(application, contracts, serviceMap, (IAsyncResultHandler<Void>)handler);
                        }
                    }

                    public void onFailure(Throwable e) {
                        if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ContractAlreadyPublished", new Object[]{contractId})), Void.class));
                        } else {
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringContract", new Object[0]), e), Void.class));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringContract", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void unregisterApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        String id = this.getApplicationId(application);
        this.getClient().prepareDelete("apiman_gateway", "application", id).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (response.isFound()) {
                    ESRegistry.this.unregisterServiceContracts(application, (IAsyncResultHandler<Void>)handler);
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.AppNotFound", new Object[0])), Void.class));
                }
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), e), Void.class));
            }
        });
    }

    protected void unregisterServiceContracts(Application application, final IAsyncResultHandler<Void> handler) {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"application.organizationId", (String)application.getOrganizationId()), FilterBuilders.termFilter((String)"application.applicationId", (String)application.getApplicationId()), FilterBuilders.termFilter((String)"application.version", (String)application.getVersion())}));
        this.getClient().prepareDeleteByQuery(new String[]{"apiman_gateway"}).setQuery((QueryBuilder)qb).setTypes(new String[]{"serviceContract"}).execute((ActionListener)new ActionListener<DeleteByQueryResponse>(){

            public void onResponse(DeleteByQueryResponse response) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), e), Void.class));
            }
        });
    }

    public void getContract(ServiceRequest request, final IAsyncResultHandler<ServiceContract> handler) {
        final String id = this.getContractId(request);
        this.getClient().prepareGet("apiman_gateway", "serviceContract", id).setFetchSource(true).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists()) {
                    InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.NoContractForAPIKey", new Object[]{id}));
                    handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                } else {
                    Map source = response.getSource();
                    ServiceContract contract = ESRegistryMarshalling.unmarshallServiceContract(source);
                    ESRegistry.this.checkService(contract, (IAsyncResultHandler<ServiceContract>)handler);
                }
            }

            public void onFailure(Throwable e) {
                if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                    InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.NoContractForAPIKey", new Object[]{id}));
                    handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
                }
            }
        });
    }

    protected void checkService(final ServiceContract contract, final IAsyncResultHandler<ServiceContract> handler) {
        final Service service = contract.getService();
        String id = this.getServiceId(service);
        this.getClient().prepareGet("apiman_gateway", "service", id).setFetchSource(false).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (response.isExists()) {
                    handler.handle((Object)AsyncResultImpl.create((Object)contract));
                } else {
                    InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
                    handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                }
            }

            public void onFailure(Throwable e) {
                if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                    InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
                    handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
                }
            }
        });
    }

    public void getService(String organizationId, String serviceId, String serviceVersion, IAsyncResultHandler<Service> handler) {
        String id = this.getServiceId(organizationId, serviceId, serviceVersion);
        this.getService(id, handler);
    }

    protected void getService(String id, final IAsyncResultHandler<Service> handler) {
        this.getClient().prepareGet("apiman_gateway", "service", id).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (response.isExists()) {
                    Map source = response.getSourceAsMap();
                    Service service = ESRegistryMarshalling.unmarshallService(source);
                    handler.handle((Object)AsyncResultImpl.create((Object)service));
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Object)null));
                }
            }

            public void onFailure(Throwable e) {
                if (ESUtils.rootCause(e) instanceof DocumentAlreadyExistsException) {
                    handler.handle((Object)AsyncResultImpl.create((Object)null));
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, Service.class));
                }
            }
        });
    }

    private String getServiceId(Service service) {
        return this.getServiceId(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceId(Contract contract) {
        return this.getServiceId(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
    }

    private String getServiceId(String orgId, String serviceId, String version) {
        return orgId + ":" + serviceId + ":" + version;
    }

    private String getApplicationId(Application app) {
        return app.getOrganizationId() + ":" + app.getApplicationId() + ":" + app.getVersion();
    }

    private String getContractId(ServiceRequest request) {
        return request.getApiKey();
    }

    private String getContractId(Contract contract) {
        return contract.getApiKey();
    }

    public synchronized Client getClient() {
        if (this.esClient == null) {
            this.esClient = ESClientFactory.createClient(this.config);
        }
        return this.esClient;
    }
}

