/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.ESRegistryMarshalling;
import io.apiman.gateway.engine.es.i18n.Messages;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ESRegistry
extends AbstractESComponent
implements IRegistry {
    public ESRegistry(Map<String, String> config) {
        super(config);
    }

    public void publishService(Service service, final IAsyncResultHandler<Void> handler) {
        try {
            String id = this.getServiceId(service);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(service).string()).refresh(false)).index("apiman_gateway")).setParameter("op_type", (Object)"create")).type("service")).id(id)).build();
            this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (!result.isSucceeded()) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceAlreadyPublished", new Object[0])), Void.class));
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Object)null));
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingService", new Object[0]), (Throwable)e), Void.class));
                }
            });
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingService", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void retireService(Service service, final IAsyncResultHandler<Void> handler) {
        String id = this.getServiceId(service);
        Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index("apiman_gateway")).type("service")).build();
        try {
            this.getClient().executeAsync((Action)delete, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (result.isSucceeded()) {
                        handler.handle((Object)AsyncResultImpl.create((Object)null));
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceNotFound", new Object[0])), Void.class));
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorRetiringService", new Object[0]), (Throwable)e), Void.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorRetiringService", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void registerApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        final HashMap<String, Service> svcMap = new HashMap<String, Service>();
        this.validateApplication(application, svcMap, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    handler.handle(result);
                } else {
                    String id = ESRegistry.this.getApplicationId(application);
                    try {
                        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(application).string()).refresh(false)).index("apiman_gateway")).setParameter("op_type", (Object)"create")).type("application")).id(id)).build();
                        ESRegistry.this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

                            public void completed(JestResult result) {
                                if (!result.isSucceeded()) {
                                    handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.AppAlreadyRegistered", new Object[0])), Void.class));
                                } else {
                                    Iterator iterator = application.getContracts().iterator();
                                    application.setContracts(null);
                                    ESRegistry.this.registerContracts(application, iterator, svcMap, (IAsyncResultHandler<Void>)handler);
                                }
                            }

                            public void failed(Exception e) {
                                handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringApplication", new Object[0]), (Throwable)e), Void.class));
                            }
                        });
                    }
                    catch (Exception e) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringApplication", new Object[0]), (Throwable)e), Void.class));
                    }
                }
            }
        });
    }

    private void validateApplication(Application application, Map<String, Service> serviceMap, IAsyncResultHandler<Void> handler) {
        Set contracts = application.getContracts();
        if (contracts.isEmpty()) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.NoContracts", new Object[0])), Void.class));
            return;
        }
        Iterator<Contract> iterator = contracts.iterator();
        this.validateServiceExists(iterator, serviceMap, handler);
    }

    private void validateServiceExists(final Iterator<Contract> iterator, final Map<String, Service> serviceMap, final IAsyncResultHandler<Void> handler) {
        if (!iterator.hasNext()) {
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        } else {
            final Contract contract = iterator.next();
            final String serviceId = this.getServiceId(contract);
            this.getService(serviceId, new IAsyncResultHandler<Service>(){

                public void handle(IAsyncResult<Service> result) {
                    if (result.isError()) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorValidatingApp", new Object[0]), result.getError()), Void.class));
                    } else {
                        Service service = (Service)result.getResult();
                        if (service == null) {
                            String serviceId2 = contract.getServiceId();
                            String orgId = contract.getServiceOrgId();
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ServiceNotFoundInOrg", new Object[]{serviceId2, orgId})), Void.class));
                        } else {
                            service.setServicePolicies(null);
                            serviceMap.put(serviceId, service);
                            ESRegistry.this.validateServiceExists(iterator, serviceMap, (IAsyncResultHandler<Void>)handler);
                        }
                    }
                }
            });
        }
    }

    private void registerContracts(final Application application, final Iterator<Contract> contracts, final Map<String, Service> serviceMap, final IAsyncResultHandler<Void> handler) {
        try {
            if (!contracts.hasNext()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                Contract contract = contracts.next();
                String svcId = this.getServiceId(contract);
                Service service = serviceMap.get(svcId);
                ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPolicies());
                final String contractId = this.getContractId(contract);
                Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(sc).string()).refresh(false)).setParameter("op_type", (Object)"create")).index("apiman_gateway")).type("serviceContract")).id(contractId)).build();
                this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

                    public void completed(JestResult result) {
                        if (!result.isSucceeded()) {
                            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ContractAlreadyPublished", new Object[]{contractId})), Void.class));
                        } else {
                            ESRegistry.this.registerContracts(application, contracts, serviceMap, (IAsyncResultHandler<Void>)handler);
                        }
                    }

                    public void failed(Exception e) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringContract", new Object[0]), (Throwable)e), Void.class));
                    }
                });
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringContract", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void unregisterApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        String id = this.getApplicationId(application);
        Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index("apiman_gateway")).type("application")).build();
        try {
            this.getClient().executeAsync((Action)delete, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (result.isSucceeded()) {
                        ESRegistry.this.unregisterServiceContracts(application, (IAsyncResultHandler<Void>)handler);
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.AppNotFound", new Object[0])), Void.class));
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), (Throwable)e), Void.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), (Throwable)e), Void.class));
        }
    }

    protected void unregisterServiceContracts(Application application, final IAsyncResultHandler<Void> handler) {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"application.organizationId", (String)application.getOrganizationId()), FilterBuilders.termFilter((String)"application.applicationId", (String)application.getApplicationId()), FilterBuilders.termFilter((String)"application.version", (String)application.getVersion())}));
        String dquery = "{\"query\" : " + qb.toString() + "}";
        DeleteByQuery delete = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(dquery).addIndex("apiman_gateway")).addType("serviceContract")).build();
        try {
            this.getClient().executeAsync((Action)delete, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    handler.handle((Object)AsyncResultImpl.create((Object)null));
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), (Throwable)e), Void.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void getContract(ServiceRequest request, final IAsyncResultHandler<ServiceContract> handler) {
        final String id = this.getContractId(request);
        Get get = ((Get.Builder)new Get.Builder("apiman_gateway", id).type("serviceContract")).build();
        try {
            this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (!result.isSucceeded()) {
                        InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.NoContractForAPIKey", new Object[]{id}));
                        handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                    } else {
                        Map source = (Map)result.getSourceAsObject(Map.class);
                        ServiceContract contract = ESRegistryMarshalling.unmarshallServiceContract(source);
                        ESRegistry.this.checkService(contract, (IAsyncResultHandler<ServiceContract>)handler);
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
        }
    }

    protected void checkService(final ServiceContract contract, final IAsyncResultHandler<ServiceContract> handler) {
        final Service service = contract.getService();
        String id = this.getServiceId(service);
        Get get = ((Get.Builder)new Get.Builder("apiman_gateway", id).type("service")).build();
        try {
            this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (result.isSucceeded()) {
                        handler.handle((Object)AsyncResultImpl.create((Object)contract));
                    } else {
                        InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
                        handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
        }
    }

    public void getService(String organizationId, String serviceId, String serviceVersion, IAsyncResultHandler<Service> handler) {
        String id = this.getServiceId(organizationId, serviceId, serviceVersion);
        this.getService(id, handler);
    }

    protected void getService(String id, final IAsyncResultHandler<Service> handler) {
        Get get = ((Get.Builder)new Get.Builder("apiman_gateway", id).type("service")).build();
        try {
            this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

                public void completed(JestResult result) {
                    if (result.isSucceeded()) {
                        Map source = (Map)result.getSourceAsObject(Map.class);
                        Service service = ESRegistryMarshalling.unmarshallService(source);
                        handler.handle((Object)AsyncResultImpl.create((Object)service));
                    } else {
                        handler.handle((Object)AsyncResultImpl.create((Object)null));
                    }
                }

                public void failed(Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e, Service.class));
                }
            });
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Service.class));
        }
    }

    private String getServiceId(Service service) {
        return this.getServiceId(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceId(Contract contract) {
        return this.getServiceId(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
    }

    private String getServiceId(String orgId, String serviceId, String version) {
        return orgId + ":" + serviceId + ":" + version;
    }

    private String getApplicationId(Application app) {
        return app.getOrganizationId() + ":" + app.getApplicationId() + ":" + app.getVersion();
    }

    private String getContractId(ServiceRequest request) {
        return request.getApiKey();
    }

    private String getContractId(Contract contract) {
        return contract.getApiKey();
    }
}

