/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.beans.PrimitiveBean;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Delete;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.common.Base64;

public class ESSharedStateComponent
extends AbstractESComponent
implements ISharedStateComponent {
    private static final ObjectMapper mapper = new ObjectMapper();

    public ESSharedStateComponent(Map<String, String> config) {
        super(config);
    }

    public <T> void getProperty(String namespace, String propertyName, final T defaultValue, final IAsyncResultHandler<T> handler) {
        if (defaultValue == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null defaultValue is not allowed.")));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("sharedStateProperty")).build();
        this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                if (result.isSucceeded()) {
                    try {
                        Object value = null;
                        value = defaultValue.getClass().isPrimitive() || defaultValue instanceof String ? ESSharedStateComponent.this.readPrimitive(result) : result.getSourceAsObject(defaultValue.getClass());
                        handler.handle((Object)AsyncResultImpl.create((Object)value));
                    }
                    catch (Exception e) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                    }
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Object)defaultValue));
                }
            }

            public void failed(Exception e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        });
    }

    public <T> void setProperty(String namespace, String propertyName, T value, final IAsyncResultHandler<Void> handler) {
        if (value == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null value is not allowed.")));
            return;
        }
        String source = null;
        try {
            if (value.getClass().isPrimitive() || value instanceof String) {
                PrimitiveBean pb = new PrimitiveBean();
                pb.setValue(String.valueOf(value));
                pb.setType(value.getClass().getName());
                source = mapper.writeValueAsString((Object)pb);
            } else {
                source = mapper.writeValueAsString(value);
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        String json = source;
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)json).refresh(false)).index(this.getIndexName())).type("sharedStateProperty")).id(id)).build();
        this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }

            public void failed(Exception ex) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)ex));
            }
        });
    }

    public <T> void clearProperty(String namespace, String propertyName, final IAsyncResultHandler<Void> handler) {
        String id = this.getPropertyId(namespace, propertyName);
        Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("sharedStateProperty")).build();
        this.getClient().executeAsync((Action)delete, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }

            public void failed(Exception ex) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)ex));
            }
        });
    }

    private String getPropertyId(String namespace, String propertyName) {
        String qn = new QName(namespace, propertyName).toString();
        return Base64.encodeBytes((byte[])qn.getBytes());
    }

    protected Object readPrimitive(JestResult result) throws Exception {
        PrimitiveBean pb = (PrimitiveBean)result.getSourceAsObject(PrimitiveBean.class);
        String value = pb.getValue();
        Class<?> c = Class.forName(pb.getType());
        if (c == String.class) {
            return value;
        }
        if (c == Long.class) {
            return Long.parseLong(value);
        }
        if (c == Integer.class) {
            return Integer.parseInt(value);
        }
        if (c == Double.class) {
            return Double.parseDouble(value);
        }
        if (c == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (c == Byte.class) {
            return Byte.parseByte(value);
        }
        if (c == Short.class) {
            return Short.parseShort(value);
        }
        if (c == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        throw new Exception("Unsupported primitive: " + c);
    }

    static {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

