/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.ESUtils;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.Base64;
import org.elasticsearch.index.engine.VersionConflictEngineException;

public class AsyncESRateLimiterComponent
extends AbstractESComponent
implements IRateLimiterComponent {
    public AsyncESRateLimiterComponent(Map<String, String> config) {
        super(config);
    }

    public void accept(final String bucketId, final RateBucketPeriod period, final long limit, final long increment, final IAsyncResultHandler<RateLimitResponse> handler) {
        final String id = this.id(bucketId);
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("rateBucket")).build();
        this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                long version;
                RateLimiterBucket bucket = null;
                if (result.isSucceeded()) {
                    version = result.getJsonObject().get("_version").getAsLong();
                    bucket = (RateLimiterBucket)result.getSourceAsObject(RateLimiterBucket.class);
                } else {
                    version = 0L;
                    bucket = new RateLimiterBucket();
                }
                bucket.resetIfNecessary(period);
                RateLimitResponse rlr = new RateLimitResponse();
                if (bucket.getCount() > limit) {
                    rlr.setAccepted(false);
                } else {
                    rlr.setAccepted(bucket.getCount() < limit);
                    bucket.setCount(bucket.getCount() + increment);
                    bucket.setLast(System.currentTimeMillis());
                }
                int reset = (int)(bucket.getResetMillis(period) / 1000L);
                rlr.setReset((long)reset);
                rlr.setRemaining(limit - bucket.getCount());
                AsyncESRateLimiterComponent.this.updateBucketAndReturn(id, bucket, rlr, version, bucketId, period, limit, increment, (IAsyncResultHandler<RateLimitResponse>)handler);
            }

            public void failed(Exception e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e, RateLimitResponse.class));
            }
        });
    }

    protected RateLimiterBucket readBucket(GetResponse response) {
        RateLimiterBucket bucket = new RateLimiterBucket();
        Map source = response.getSourceAsMap();
        bucket.setCount((long)((Number)source.get("count")).intValue());
        bucket.setLast(((Number)source.get("last")).longValue());
        return bucket;
    }

    protected void updateBucketAndReturn(String id, RateLimiterBucket bucket, final RateLimitResponse rlr, long version, final String bucketId, final RateBucketPeriod period, final long limit, final long increment, final IAsyncResultHandler<RateLimitResponse> handler) {
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)bucket).refresh(false)).index(this.getIndexName())).setParameter("op_type", (Object)"index")).setParameter("version", (Object)String.valueOf(version))).type("rateBucket")).id(id)).build();
        this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                handler.handle((Object)AsyncResultImpl.create((Object)rlr));
            }

            public void failed(Exception e) {
                if (ESUtils.rootCause(e) instanceof VersionConflictEngineException) {
                    AsyncESRateLimiterComponent.this.accept(bucketId, period, limit, increment, (IAsyncResultHandler<RateLimitResponse>)handler);
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                }
            }
        });
    }

    private String id(String bucketId) {
        return Base64.encodeBytes((byte[])bucketId.getBytes());
    }

    @Override
    protected String getIndexName() {
        return "apiman_gateway";
    }
}

