/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.DependsOnComponents;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.ESCacheEntry;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalReadStream;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

@DependsOnComponents(value={IBufferFactoryComponent.class})
public class ESCacheStoreComponent
extends AbstractESComponent
implements ICacheStoreComponent {
    private static final ObjectMapper mapper = new ObjectMapper();
    private IBufferFactoryComponent bufferFactory;

    public ESCacheStoreComponent(Map<String, String> config) {
        super(config);
    }

    public void setBufferFactory(IBufferFactoryComponent bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public <T> void put(String cacheKey, T jsonObject, long timeToLive) throws IOException {
        ESCacheEntry entry = new ESCacheEntry();
        entry.setData(null);
        entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
        entry.setHead(mapper.writeValueAsString((Object)entry));
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)entry).refresh(false)).index(this.getIndexName())).type("cacheEntry")).id(cacheKey)).build();
        try {
            this.getClient().execute((Action)index);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public <T> ISignalWriteStream putBinary(final String cacheKey, T jsonObject, long timeToLive) throws IOException {
        final ESCacheEntry entry = new ESCacheEntry();
        entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
        entry.setHead(mapper.writeValueAsString(jsonObject));
        final IApimanBuffer data = this.bufferFactory.createBuffer();
        return new ISignalWriteStream(){
            boolean finished = false;
            boolean aborted = false;

            public void abort() {
                this.finished = true;
                this.aborted = false;
            }

            public boolean isFinished() {
                return this.finished;
            }

            public void write(IApimanBuffer chunk) {
                data.append(chunk);
            }

            public void end() {
                if (!this.aborted) {
                    entry.setData(Base64.encodeBase64String((byte[])data.getBytes()));
                    Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)entry).refresh(false)).index(ESCacheStoreComponent.this.getIndexName())).type("cacheEntry")).id(cacheKey)).build();
                    try {
                        ESCacheStoreComponent.this.getClient().execute((Action)index);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.finished = true;
            }
        };
    }

    public <T> void get(String cacheKey, Class<T> type, IAsyncResultHandler<T> handler) {
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), cacheKey).type("cacheEntry")).build();
        try {
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                ESCacheEntry cacheEntry = (ESCacheEntry)result.getSourceAsObject(ESCacheEntry.class);
                try {
                    Object rval = mapper.reader(type).readValue(cacheEntry.getHead());
                    handler.handle((Object)AsyncResultImpl.create((Object)rval));
                }
                catch (IOException e) {
                    handler.handle((Object)AsyncResultImpl.create((Object)null));
                }
            } else {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, type));
        }
    }

    public <T> void getBinary(String cacheKey, Class<T> type, IAsyncResultHandler<ISignalReadStream<T>> handler) {
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), cacheKey).type("cacheEntry")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (!result.isSucceeded()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
                return;
            }
            ESCacheEntry cacheEntry = (ESCacheEntry)result.getSourceAsObject(ESCacheEntry.class);
            if (System.currentTimeMillis() > cacheEntry.getExpiresOn()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
                return;
            }
            try {
                final Object head = mapper.reader(type).readValue(cacheEntry.getHead());
                String b64Data = cacheEntry.getData();
                final IApimanBuffer data = this.bufferFactory.createBuffer(Base64.decodeBase64((String)b64Data));
                ISignalReadStream rval = new ISignalReadStream<T>(){
                    IAsyncHandler<IApimanBuffer> bodyHandler;
                    IAsyncHandler<Void> endHandler;
                    boolean finished = false;
                    boolean aborted = false;

                    public void bodyHandler(IAsyncHandler<IApimanBuffer> bodyHandler) {
                        this.bodyHandler = bodyHandler;
                    }

                    public void endHandler(IAsyncHandler<Void> endHandler) {
                        this.endHandler = endHandler;
                    }

                    public T getHead() {
                        return head;
                    }

                    public boolean isFinished() {
                        return this.finished;
                    }

                    public void abort() {
                        this.finished = true;
                        this.aborted = true;
                    }

                    public void transmit() {
                        if (!this.aborted) {
                            this.bodyHandler.handle((Object)data);
                            this.endHandler.handle(null);
                        }
                        this.finished = true;
                    }
                };
                handler.handle((Object)AsyncResultImpl.create((Object)rval));
            }
            catch (Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
    }

    @Override
    protected String getIndexName() {
        return "apiman_cache";
    }

    static {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

