/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.cluster.Health;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;

public class ESClientFactory {
    private static Map<String, JestClient> clients = new HashMap<String, JestClient>();

    public static void clearClientCache() {
        clients.clear();
    }

    public static JestClient createClient(Map<String, String> config, String indexName) {
        JestClient client = null;
        String clientType = config.get("client.type");
        if (clientType == null) {
            clientType = "jest";
        }
        if ("jest".equals(clientType)) {
            client = ESClientFactory.createJestClient(config, indexName);
        } else if ("local".equals(clientType)) {
            client = ESClientFactory.createLocalClient(config, indexName);
        } else {
            throw new RuntimeException("Invalid elasticsearch client type: " + clientType);
        }
        return client;
    }

    public static JestClient createJestClient(Map<String, String> config, String indexName) {
        String host = config.get("client.host");
        String port = config.get("client.port");
        String protocol = config.get("client.protocol");
        String initialize = config.get("client.initialize");
        if (initialize == null) {
            initialize = "true";
        }
        String username = config.get("client.username");
        String password = config.get("client.password");
        if (StringUtils.isBlank((String)host)) {
            throw new RuntimeException("Missing client.host configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((String)port)) {
            throw new RuntimeException("Missing client.port configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((String)protocol)) {
            protocol = "http";
        }
        return ESClientFactory.createJestClient(protocol, host, Integer.parseInt(port), indexName, username, password, "true".equals(initialize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JestClient createJestClient(String protocol, String host, int port, String indexName, String username, String password, boolean initialize) {
        String clientKey = "jest:" + host + ':' + port + '/' + indexName;
        Map<String, JestClient> map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return clients.get(clientKey);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(protocol);
            builder.append("://");
            builder.append(host);
            builder.append(":");
            builder.append(String.valueOf(port));
            String connectionUrl = builder.toString();
            JestClientFactory factory = new JestClientFactory();
            HttpClientConfig.Builder httpClientConfig = (HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).maxTotalConnection(75).defaultMaxTotalConnectionPerRoute(75).multiThreaded(true);
            if (!StringUtils.isBlank((String)username)) {
                httpClientConfig.defaultCredentials(username, password);
            }
            factory.setHttpClientConfig(httpClientConfig.build());
            JestClient client = factory.getObject();
            clients.put(clientKey, client);
            if (initialize) {
                ESClientFactory.initializeClient(client, indexName);
            }
            return client;
        }
    }

    public static JestClient createLocalClient(Map<String, String> config, String indexName) {
        String clientLocClassName = config.get("client.class");
        String clientLocFieldName = config.get("client.field");
        return ESClientFactory.createLocalClient(clientLocClassName, clientLocFieldName, indexName);
    }

    public static JestClient createLocalClient(String className, String fieldName, String indexName) {
        String clientKey = "local:" + className + '/' + fieldName;
        Map<String, JestClient> map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return clients.get(clientKey);
            }
            try {
                Class<?> clientLocClass = Class.forName(className);
                Field field = clientLocClass.getField(fieldName);
                JestClient client = (JestClient)field.get(null);
                clients.put(clientKey, client);
                ESClientFactory.initializeClient(client, indexName);
                return client;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Error using local elasticsearch client.", e);
            }
        }
    }

    public static void initializeClient(JestClient client, String indexName) {
        try {
            client.execute((Action)new Health.Builder().build());
            IndicesExists action = new IndicesExists.Builder(indexName).build();
            JestResult result = client.execute((Action)action);
            if (!result.isSucceeded()) {
                ESClientFactory.createIndex(client, indexName, indexName + "-settings.json");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void createIndex(JestClient client, String indexName, String settingsName) throws Exception {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        URL settings = ESClientFactory.class.getResource(settingsName);
        String source = IOUtils.toString((URL)settings);
        request.source(source);
        JestResult response = client.execute((Action)new CreateIndex.Builder(indexName).settings((Object)source).build());
        if (!response.isSucceeded()) {
            throw new Exception("Failed to create index: " + indexName);
        }
    }
}

