/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.ESRegistryMarshalling;
import io.apiman.gateway.engine.es.i18n.Messages;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ESRegistry
extends AbstractESComponent
implements IRegistry {
    public ESRegistry(Map<String, String> config) {
        super(config);
    }

    public void publishService(Service service, IAsyncResultHandler<Void> handler) {
        try {
            String id = this.getServiceId(service);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(service).string()).refresh(false)).index(this.getIndexName())).setParameter("op_type", (Object)"create")).type("service")).id(id)).build();
            JestResult result = this.getClient().execute((Action)index);
            if (!result.isSucceeded()) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceAlreadyPublished", new Object[0])), Void.class));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingService", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void retireService(Service service, IAsyncResultHandler<Void> handler) {
        String id = this.getServiceId(service);
        try {
            Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("service")).build();
            JestResult result = this.getClient().execute((Action)delete);
            if (result.isSucceeded()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ServiceNotFound", new Object[0])), Void.class));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorRetiringService", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void registerApplication(Application application, IAsyncResultHandler<Void> handler) {
        HashMap<String, Service> svcMap = new HashMap<String, Service>();
        try {
            this.validateApplication(application, svcMap);
            String id = this.getApplicationId(application);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(application).string()).refresh(false)).index(this.getIndexName())).setParameter("op_type", (Object)"create")).type("application")).id(id)).build();
            JestResult result = this.getClient().execute((Action)index);
            if (!result.isSucceeded()) {
                throw new RegistrationException(Messages.i18n.format("ESRegistry.AppAlreadyRegistered", new Object[0]));
            }
            Set contracts = application.getContracts();
            application.setContracts(null);
            for (Contract contract : contracts) {
                this.registerContract(application, contract, svcMap);
            }
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringApplication", new Object[0]), (Throwable)e), Void.class));
        }
        catch (RegistrationException re) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)re, Void.class));
        }
    }

    private void validateApplication(Application application, Map<String, Service> serviceMap) throws RegistrationException {
        Set contracts = application.getContracts();
        if (contracts.isEmpty()) {
            throw new RegistrationException(Messages.i18n.format("ESRegistry.NoContracts", new Object[0]));
        }
        for (Contract contract : contracts) {
            this.validateContract(contract, serviceMap);
        }
    }

    private void validateContract(Contract contract, Map<String, Service> serviceMap) throws RegistrationException {
        String serviceId = this.getServiceId(contract);
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), serviceId).type("service")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (!result.isSucceeded()) {
                String svcId = contract.getServiceId();
                String orgId = contract.getServiceOrgId();
                throw new RegistrationException(Messages.i18n.format("ESRegistry.ServiceNotFoundInOrg", new Object[]{svcId, orgId}));
            }
            Map source = (Map)result.getSourceAsObject(Map.class);
            Service service = ESRegistryMarshalling.unmarshallService(source);
            service.setServicePolicies(null);
            serviceMap.put(serviceId, service);
        }
        catch (IOException e) {
            throw new RegistrationException(Messages.i18n.format("ESRegistry.ErrorValidatingApp", new Object[0]), (Throwable)e);
        }
    }

    private void registerContract(Application application, Contract contract, Map<String, Service> serviceMap) throws RegistrationException {
        try {
            String svcId = this.getServiceId(contract);
            Service service = serviceMap.get(svcId);
            ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPlan(), contract.getPolicies());
            String contractId = this.getContractId(contract);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)ESRegistryMarshalling.marshall(sc).string()).refresh(false)).setParameter("op_type", (Object)"create")).index(this.getIndexName())).type("serviceContract")).id(contractId)).build();
            JestResult result = this.getClient().execute((Action)index);
            if (!result.isSucceeded()) {
                throw new RegistrationException(Messages.i18n.format("ESRegistry.ContractAlreadyPublished", new Object[]{contractId}));
            }
        }
        catch (Exception e) {
            throw new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringContract", new Object[0]), (Throwable)e);
        }
    }

    public void unregisterApplication(Application application, IAsyncResultHandler<Void> handler) {
        String id = this.getApplicationId(application);
        try {
            Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("application")).build();
            JestResult result = this.getClient().execute((Action)delete);
            if (result.isSucceeded()) {
                this.unregisterServiceContracts(application);
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.AppNotFound", new Object[0])), Void.class));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringApp", new Object[0]), (Throwable)e), Void.class));
        }
    }

    protected void unregisterServiceContracts(Application application) throws IOException {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"application.organizationId", (String)application.getOrganizationId()), FilterBuilders.termFilter((String)"application.applicationId", (String)application.getApplicationId()), FilterBuilders.termFilter((String)"application.version", (String)application.getVersion())}));
        String dquery = "{\"query\" : " + qb.toString() + "}";
        DeleteByQuery delete = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(dquery).addIndex(this.getIndexName())).addType("serviceContract")).build();
        this.getClient().execute((Action)delete);
    }

    public void getContract(ServiceRequest request, IAsyncResultHandler<ServiceContract> handler) {
        String id = this.getContractId(request);
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("serviceContract")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (!result.isSucceeded()) {
                InvalidContractException error = new InvalidContractException(Messages.i18n.format("ESRegistry.NoContractForAPIKey", new Object[]{id}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ServiceContract.class));
            } else {
                Map source = (Map)result.getSourceAsObject(Map.class);
                ServiceContract contract = ESRegistryMarshalling.unmarshallServiceContract(source);
                this.checkService(contract);
                handler.handle((Object)AsyncResultImpl.create((Object)contract));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ServiceContract.class));
        }
    }

    protected void checkService(ServiceContract contract) throws InvalidContractException, IOException {
        Service service = contract.getService();
        String id = this.getServiceId(service);
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("service")).build();
        JestResult result = this.getClient().execute((Action)get);
        if (!result.isSucceeded()) {
            throw new InvalidContractException(Messages.i18n.format("ESRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
        }
    }

    public void getService(String organizationId, String serviceId, String serviceVersion, IAsyncResultHandler<Service> handler) {
        String id = this.getServiceId(organizationId, serviceId, serviceVersion);
        this.getService(id, handler);
    }

    protected void getService(String id, IAsyncResultHandler<Service> handler) {
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("service")).build();
        try {
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                Map source = (Map)result.getSourceAsObject(Map.class);
                Service service = ESRegistryMarshalling.unmarshallService(source);
                handler.handle((Object)AsyncResultImpl.create((Object)service));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Service.class));
        }
    }

    private String getServiceId(Service service) {
        return this.getServiceId(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceId(Contract contract) {
        return this.getServiceId(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
    }

    private String getServiceId(String orgId, String serviceId, String version) {
        return orgId + ":" + serviceId + ":" + version;
    }

    private String getApplicationId(Application app) {
        return app.getOrganizationId() + ":" + app.getApplicationId() + ":" + app.getVersion();
    }

    private String getContractId(ServiceRequest request) {
        return request.getApiKey();
    }

    private String getContractId(Contract contract) {
        return contract.getApiKey();
    }

    @Override
    protected String getIndexName() {
        return "apiman_gateway";
    }
}

