/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ESRegistryMarshalling {
    public static XContentBuilder marshall(Service bean) throws Exception {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        ESRegistryMarshalling.marshallInto(bean, builder);
        return builder;
    }

    protected static void marshallInto(Service bean, XContentBuilder builder) throws IOException {
        List policies;
        builder.startObject().field("endpoint", bean.getEndpoint()).field("endpointType", bean.getEndpointType()).field("publicService", bean.isPublicService()).field("organizationId", bean.getOrganizationId()).field("serviceId", bean.getServiceId()).field("version", bean.getVersion());
        Map endpointProperties = bean.getEndpointProperties();
        if (endpointProperties != null) {
            builder.startArray("endpointProperties");
            for (Map.Entry entry : endpointProperties.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                builder.startObject().field(key, val).endObject();
            }
            builder.endArray();
        }
        if ((policies = bean.getServicePolicies()) != null) {
            builder.startArray("policies");
            for (Policy policy : policies) {
                builder.startObject().field("policyImpl", policy.getPolicyImpl()).field("policyJsonConfig", policy.getPolicyJsonConfig()).endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static Service unmarshallService(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        Service bean = new Service();
        bean.setEndpoint(ESRegistryMarshalling.asString(source.get("endpoint")));
        bean.setEndpointProperties(ESRegistryMarshalling.asStringMap(source.get("endpointProperties")));
        bean.setEndpointType(ESRegistryMarshalling.asString(source.get("endpointType")));
        bean.setOrganizationId(ESRegistryMarshalling.asString(source.get("organizationId")));
        bean.setPublicService(ESRegistryMarshalling.asBoolean(source.get("publicService")).booleanValue());
        bean.setServiceId(ESRegistryMarshalling.asString(source.get("serviceId")));
        bean.setVersion(ESRegistryMarshalling.asString(source.get("version")));
        List policies = (List)source.get("policies");
        if (policies != null) {
            for (Map policySource : policies) {
                Policy policy = new Policy();
                policy.setPolicyImpl(ESRegistryMarshalling.asString(policySource.get("policyImpl")));
                policy.setPolicyJsonConfig(ESRegistryMarshalling.asString(policySource.get("policyJsonConfig")));
                bean.getServicePolicies().add(policy);
            }
        }
        return bean;
    }

    public static XContentBuilder marshall(Application bean) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        ESRegistryMarshalling.marshallInto(bean, builder);
        return builder;
    }

    private static void marshallInto(Application bean, XContentBuilder builder) throws IOException {
        builder.startObject().field("organizationId", bean.getOrganizationId()).field("applicationId", bean.getApplicationId()).field("version", bean.getVersion());
        Set contracts = bean.getContracts();
        if (contracts != null) {
            builder.startArray("contracts");
            for (Contract contract : contracts) {
                builder.startObject().field("apiKey", contract.getApiKey()).field("plan", contract.getPlan()).field("serviceOrgId", contract.getServiceOrgId()).field("serviceId", contract.getServiceId()).field("serviceVersion", contract.getServiceVersion());
                List policies = contract.getPolicies();
                if (policies != null) {
                    builder.startArray("policies");
                    for (Policy policy : policies) {
                        builder.startObject().field("policyImpl", policy.getPolicyImpl()).field("policyJsonConfig", policy.getPolicyJsonConfig()).endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static Application unmarshallApplication(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        Application bean = new Application();
        bean.setOrganizationId(ESRegistryMarshalling.asString(source.get("organizationId")));
        bean.setApplicationId(ESRegistryMarshalling.asString(source.get("applicationId")));
        bean.setVersion(ESRegistryMarshalling.asString(source.get("version")));
        List contracts = (List)source.get("contracts");
        if (contracts != null) {
            for (Map contractSource : contracts) {
                Contract contract = new Contract();
                contract.setApiKey(ESRegistryMarshalling.asString(contractSource.get("apiKey")));
                contract.setPlan(ESRegistryMarshalling.asString(contractSource.get("plan")));
                contract.setServiceOrgId(ESRegistryMarshalling.asString(contractSource.get("serviceOrgId")));
                contract.setServiceId(ESRegistryMarshalling.asString(contractSource.get("serviceId")));
                contract.setServiceVersion(ESRegistryMarshalling.asString(contractSource.get("serviceVersion")));
                List policies = (List)contractSource.get("policies");
                if (policies != null) {
                    for (Map policySource : policies) {
                        Policy policy = new Policy();
                        policy.setPolicyImpl(ESRegistryMarshalling.asString(policySource.get("policyImpl")));
                        policy.setPolicyJsonConfig(ESRegistryMarshalling.asString(policySource.get("policyJsonConfig")));
                        contract.getPolicies().add(policy);
                    }
                }
                bean.getContracts().add(contract);
            }
        }
        return bean;
    }

    public static XContentBuilder marshall(ServiceContract bean) throws Exception {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.field("apiKey", bean.getApikey());
        builder.field("plan", bean.getPlan());
        builder.field("application");
        ESRegistryMarshalling.marshallInto(bean.getApplication(), builder);
        builder.field("service");
        ESRegistryMarshalling.marshallInto(bean.getService(), builder);
        List policies = bean.getPolicies();
        if (policies != null) {
            builder.startArray("policies");
            for (Policy policy : policies) {
                builder.startObject().field("policyImpl", policy.getPolicyImpl()).field("policyJsonConfig", policy.getPolicyJsonConfig()).endObject();
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public static ServiceContract unmarshallServiceContract(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        ServiceContract contract = new ServiceContract();
        contract.setApikey(ESRegistryMarshalling.asString(source.get("apiKey")));
        contract.setApplication(ESRegistryMarshalling.unmarshallApplication((Map)source.get("application")));
        contract.setService(ESRegistryMarshalling.unmarshallService((Map)source.get("service")));
        contract.setPlan(ESRegistryMarshalling.asString(source.get("plan")));
        List policies = (List)source.get("policies");
        if (policies != null) {
            for (Map policySource : policies) {
                Policy policy = new Policy();
                policy.setPolicyImpl(ESRegistryMarshalling.asString(policySource.get("policyImpl")));
                policy.setPolicyJsonConfig(ESRegistryMarshalling.asString(policySource.get("policyJsonConfig")));
                contract.getPolicies().add(policy);
            }
        }
        return contract;
    }

    private static String asString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    private static Map<String, String> asStringMap(Object object) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (object != null) {
            List data = (List)object;
            for (Map entry : data) {
                String key = (String)entry.keySet().iterator().next();
                String val = String.valueOf(entry.get(key));
                map.put(key, val);
            }
        }
        return map;
    }

    private static Boolean asBoolean(Object object) {
        if (object == null) {
            return null;
        }
        return (Boolean)object;
    }
}

