/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.es.CachingESRegistry;
import io.apiman.gateway.engine.es.beans.DataVersionBean;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.Map;

public class PollCachingESRegistry
extends CachingESRegistry {
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private int pollIntervalSeconds;
    private boolean polling = false;
    private Object poller = new Object();
    private String dataVersion = null;

    public PollCachingESRegistry(Map<String, String> config) {
        super(config);
        String intervalVal = config.get("cache-polling-interval");
        this.pollIntervalSeconds = intervalVal != null ? new Integer(intervalVal) * 1000 : 10000;
        this.startCacheInvalidator();
    }

    @Override
    public void publishService(Service service, final IAsyncResultHandler<Void> handler) {
        super.publishService(service, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void retireService(Service service, final IAsyncResultHandler<Void> handler) {
        super.retireService(service, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void registerApplication(Application application, final IAsyncResultHandler<Void> handler) {
        super.registerApplication(application, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void unregisterApplication(Application application, final IAsyncResultHandler<Void> handler) {
        super.unregisterApplication(application, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    protected void updateDataVersion() {
        DataVersionBean dv = new DataVersionBean();
        dv.setUpdatedOn(System.currentTimeMillis());
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)dv).refresh(false)).index(this.getIndexName())).type("dataVersion")).id("instance")).build();
        this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                PollCachingESRegistry.this.dataVersion = null;
            }

            public void failed(Exception e) {
                PollCachingESRegistry.this.dataVersion = null;
            }
        });
    }

    protected void startCacheInvalidator() {
        this.polling = true;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (PollCachingESRegistry.this.polling) {
                    try {
                        Object object = PollCachingESRegistry.this.poller;
                        synchronized (object) {
                            PollCachingESRegistry.this.poller.wait(PollCachingESRegistry.this.pollIntervalSeconds);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PollCachingESRegistry.this.checkCacheVersion();
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("PollCachingESInvalidator");
        thread.start();
    }

    protected void finalize() throws Throwable {
        this.polling = false;
        super.finalize();
    }

    protected void checkCacheVersion() {
        boolean invalidate = true;
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), "instance").type("dataVersion")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                String latestDV = result.getJsonObject().get("_version").getAsString();
                if (latestDV != null && this.dataVersion != null && latestDV.equals(this.dataVersion)) {
                    invalidate = false;
                } else {
                    this.dataVersion = latestDV;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (invalidate) {
            this.invalidateCache();
        }
    }
}

