/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.es.ESRegistry;
import io.apiman.gateway.engine.es.ESRegistryMarshalling;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Get;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CachingESRegistry
extends ESRegistry {
    private Map<String, ServiceContract> contractCache = new ConcurrentHashMap<String, ServiceContract>();
    private Map<String, Service> serviceCache = new HashMap<String, Service>();
    private Map<String, Application> applicationCache = new HashMap<String, Application>();
    private Object mutex = new Object();

    public CachingESRegistry(Map<String, String> config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateCache() {
        Object object = this.mutex;
        synchronized (object) {
            this.contractCache.clear();
            this.serviceCache.clear();
            this.applicationCache.clear();
        }
    }

    @Override
    public void publishService(final Service service, final IAsyncResultHandler<Void> handler) {
        super.publishService(service, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    CachingESRegistry.this.cacheService(service);
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void registerApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        final Set contracts = application.getContracts();
        super.registerApplication(application, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    application.setContracts(contracts);
                    CachingESRegistry.this.cacheApplication(application);
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void retireService(final Service service, final IAsyncResultHandler<Void> handler) {
        super.retireService(service, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    CachingESRegistry.this.decacheService(service);
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void unregisterApplication(final Application application, final IAsyncResultHandler<Void> handler) {
        super.unregisterApplication(application, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    CachingESRegistry.this.decacheApplication(application);
                }
                handler.handle(result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getContract(ServiceRequest request, final IAsyncResultHandler<ServiceContract> handler) {
        String contractKey = this.getContractKey(request);
        Object object = this.mutex;
        synchronized (object) {
            ServiceContract contract = this.contractCache.get(contractKey);
            if (contract != null) {
                String serviceKey = this.getServiceKey(contract.getService());
                Service service = this.serviceCache.get(serviceKey);
                if (service == null) {
                    super.getContract(request, handler);
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Object)contract));
                }
            } else {
                super.getContract(request, new IAsyncResultHandler<ServiceContract>(){

                    public void handle(IAsyncResult<ServiceContract> result) {
                        if (result.isSuccess()) {
                            CachingESRegistry.this.loadAndCacheApp(((ServiceContract)result.getResult()).getApplication());
                        }
                        handler.handle(result);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getService(String organizationId, String serviceId, String serviceVersion, final IAsyncResultHandler<Service> handler) {
        Object object = this.mutex;
        synchronized (object) {
            String serviceKey = this.getServiceKey(organizationId, serviceId, serviceVersion);
            Service service = this.serviceCache.get(serviceKey);
            if (service != null) {
                handler.handle((Object)AsyncResultImpl.create((Object)service));
            } else {
                super.getService(organizationId, serviceId, serviceVersion, new IAsyncResultHandler<Service>(){

                    public void handle(IAsyncResult<Service> result) {
                        if (result.isSuccess()) {
                            Service svc = (Service)result.getResult();
                            CachingESRegistry.this.cacheService(svc);
                        }
                        handler.handle(result);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheService(Service service) {
        if (service != null) {
            String serviceKey = this.getServiceKey(service);
            Object object = this.mutex;
            synchronized (object) {
                this.serviceCache.put(serviceKey, service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheApplication(Application application) {
        String applicationKey = this.getApplicationKey(application);
        Object object = this.mutex;
        synchronized (object) {
            this.applicationCache.put(applicationKey, application);
            if (application.getContracts() != null) {
                for (Contract contract : application.getContracts()) {
                    String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
                    Service service = this.serviceCache.get(svcKey);
                    ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPlan(), contract.getPolicies());
                    String contractKey = this.getContractKey(contract);
                    this.contractCache.put(contractKey, sc);
                }
            }
        }
    }

    protected void loadAndCacheApp(Application application) {
        String id = this.getApplicationKey(application);
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("application")).build();
        this.getClient().executeAsync((Action)get, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                if (result.isSucceeded()) {
                    Map source = (Map)result.getSourceAsObject(Map.class);
                    Application app = ESRegistryMarshalling.unmarshallApplication(source);
                    CachingESRegistry.this.cacheApplication(app);
                }
            }

            public void failed(Exception e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decacheService(Service service) {
        String serviceKey = this.getServiceKey(service);
        Object object = this.mutex;
        synchronized (object) {
            if (this.serviceCache.containsKey(serviceKey)) {
                this.serviceCache.remove(serviceKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decacheApplication(Application application) {
        String applicationKey = this.getApplicationKey(application);
        Object object = this.mutex;
        synchronized (object) {
            if (this.applicationCache.containsKey(applicationKey)) {
                Application app = this.applicationCache.remove(applicationKey);
                for (Contract contract : app.getContracts()) {
                    String contractKey = this.getContractKey(contract);
                    if (!this.contractCache.containsKey(contractKey)) continue;
                    this.contractCache.remove(contractKey);
                }
            }
        }
    }

    private String getServiceKey(Service service) {
        return this.getServiceKey(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceKey(String orgId, String serviceId, String version) {
        return "SVC::" + orgId + "|" + serviceId + "|" + version;
    }

    private String getApplicationKey(Application app) {
        return "APP::" + app.getOrganizationId() + "|" + app.getApplicationId() + "|" + app.getVersion();
    }

    private String getContractKey(ServiceRequest request) {
        return "CONTRACT::" + request.getApiKey();
    }

    private String getContractKey(Contract contract) {
        return "CONTRACT::" + contract.getApiKey();
    }
}

