/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.ispn.i18n.Messages;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class InfinispanRegistry
implements IRegistry {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "registry";
    private String cacheContainer;
    private String cacheName;
    private Cache<Object, Object> cache;

    public InfinispanRegistry() {
        this.cacheContainer = DEFAULT_CACHE_CONTAINER;
        this.cacheName = DEFAULT_CACHE;
    }

    public InfinispanRegistry(String cacheContainer, String cacheName) {
        this.cacheContainer = cacheContainer;
        this.cacheName = cacheName;
    }

    public synchronized void publishService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (this.getCache().containsKey((Object)serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InfinispanRegistry.ServiceAlreadyPublished", new Object[0]));
        }
        this.getCache().put((Object)serviceKey, (Object)service);
    }

    public synchronized void retireService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (!this.getCache().containsKey((Object)serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InfinispanRegistry.ServiceNotFound", new Object[0]));
        }
        this.getCache().remove((Object)serviceKey);
    }

    public synchronized void registerApplication(Application application) throws RegistrationException {
        String svcKey;
        for (Contract contract : application.getContracts()) {
            String contractKey = this.getContractKey(contract);
            if (this.getCache().containsKey((Object)contractKey)) {
                throw new RegistrationException(Messages.i18n.format("InfinispanRegistry.ContractAlreadyPublished", new Object[]{contract.getApiKey()}));
            }
            svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            if (this.getCache().containsKey((Object)svcKey)) continue;
            throw new RegistrationException(Messages.i18n.format("InfinispanRegistry.ServiceNotFoundInOrg", new Object[]{contract.getServiceId(), contract.getServiceOrgId()}));
        }
        String applicationKey = this.getApplicationKey(application);
        if (this.getCache().containsKey((Object)applicationKey)) {
            throw new RegistrationException(Messages.i18n.format("InfinispanRegistry.AppAlreadyRegistered", new Object[0]));
        }
        this.getCache().put((Object)applicationKey, (Object)application);
        for (Contract contract : application.getContracts()) {
            svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            Service service = (Service)this.getCache().get((Object)svcKey);
            ServiceContract sc = new ServiceContract(contract.getApiKey(), service, application, contract.getPolicies());
            String contractKey = this.getContractKey(contract);
            this.getCache().put((Object)contractKey, (Object)sc);
        }
    }

    public synchronized void unregisterApplication(Application application) throws RegistrationException {
        String applicationKey = this.getApplicationKey(application);
        if (this.getCache().containsKey((Object)applicationKey)) {
            Application removed = (Application)this.getCache().remove((Object)applicationKey);
            for (Contract contract : removed.getContracts()) {
                String contractKey = this.getContractKey(contract);
                if (!this.getCache().containsKey((Object)contractKey)) continue;
                this.getCache().remove((Object)contractKey);
            }
        } else {
            throw new RegistrationException(Messages.i18n.format("InfinispanRegistry.AppNotFound", new Object[0]));
        }
    }

    public ServiceContract getContract(ServiceRequest request) throws InvalidContractException {
        String contractKey = this.getContractKey(request);
        ServiceContract contract = (ServiceContract)this.getCache().get((Object)contractKey);
        if (contract == null) {
            throw new InvalidContractException(Messages.i18n.format("InfinispanRegistry.NoContractForAPIKey", new Object[]{request.getApiKey()}));
        }
        Service service = contract.getService();
        String serviceKey = this.getServiceKey(service);
        if (this.getCache().get((Object)serviceKey) == null) {
            throw new InvalidContractException(Messages.i18n.format("InfinispanRegistry.ServiceWasRetired", new Object[]{service.getServiceId(), service.getOrganizationId()}));
        }
        return contract;
    }

    private String getServiceKey(Service service) {
        return this.getServiceKey(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceKey(String orgId, String serviceId, String version) {
        return "SVC::" + orgId + "|" + serviceId + "|" + version;
    }

    private String getApplicationKey(Application app) {
        return "APP::" + app.getOrganizationId() + "|" + app.getApplicationId() + "|" + app.getVersion();
    }

    private String getContractKey(ServiceRequest request) {
        return "CONTRACT::" + request.getApiKey();
    }

    private String getContractKey(Contract contract) {
        return "CONTRACT::" + contract.getApiKey();
    }

    private Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

