/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class InfinispanRateLimiterComponent
implements IRateLimiterComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "rate-limiter";
    private String cacheContainer = "java:jboss/infinispan/container/apiman-gateway";
    private String cacheName = "rate-limiter";
    private Cache<Object, Object> cache;

    public InfinispanRateLimiterComponent() {
    }

    public InfinispanRateLimiterComponent(Map<String, String> config) {
        if (config.containsKey("cache-container")) {
            this.cacheContainer = config.get("cache-container");
        }
        if (config.containsKey("cache")) {
            this.cacheName = config.get("cache");
        }
    }

    private Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String bucketId, RateBucketPeriod period, int limit, IAsyncResultHandler<Boolean> handler) {
        RateLimiterBucket bucket = null;
        Object object = this.getCache();
        synchronized (object) {
            bucket = (RateLimiterBucket)this.getCache().get((Object)bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.getCache().put((Object)bucketId, (Object)bucket);
            }
        }
        object = bucket.mutex;
        synchronized (object) {
            bucket.resetIfNecessary(period);
            if (bucket.count >= limit) {
                handler.handle((Object)AsyncResultImpl.create((Object)Boolean.FALSE));
            } else {
                ++bucket.count;
                bucket.last = System.currentTimeMillis();
                handler.handle((Object)AsyncResultImpl.create((Object)Boolean.TRUE));
            }
        }
    }
}

