/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.ispn.AbstractInfinispanComponent;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.Collections;
import java.util.Map;

public class InfinispanRateLimiterComponent
extends AbstractInfinispanComponent
implements IRateLimiterComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "rate-limiter";
    private Object mutex = new Object();

    public InfinispanRateLimiterComponent() {
        this(Collections.EMPTY_MAP);
    }

    public InfinispanRateLimiterComponent(Map<String, String> config) {
        super(config, DEFAULT_CACHE_CONTAINER, DEFAULT_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        RateLimiterBucket bucket = null;
        Object object = this.mutex;
        synchronized (object) {
            bucket = (RateLimiterBucket)this.getCache().get((Object)bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.getCache().put((Object)bucketId, (Object)bucket);
            }
            bucket.resetIfNecessary(period);
            RateLimitResponse response = new RateLimitResponse();
            if (bucket.getCount() > limit) {
                response.setAccepted(false);
            } else {
                bucket.setCount(bucket.getCount() + increment);
                bucket.setLast(System.currentTimeMillis());
                response.setAccepted(bucket.getCount() <= limit);
            }
            int reset = (int)(bucket.getResetMillis(period) / 1000L);
            response.setReset((long)reset);
            response.setRemaining(limit - bucket.getCount());
            handler.handle((Object)AsyncResultImpl.create((Object)response));
            this.getCache().put((Object)bucketId, (Object)bucket);
        }
    }
}

