/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.ispn.AbstractInfinispanComponent;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;

public class InfinispanSharedStateComponent
extends AbstractInfinispanComponent
implements ISharedStateComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "shared-state";

    public InfinispanSharedStateComponent() {
        this(Collections.EMPTY_MAP);
    }

    public InfinispanSharedStateComponent(Map<String, String> config) {
        super(config, DEFAULT_CACHE_CONTAINER, DEFAULT_CACHE);
    }

    public <T> void getProperty(String namespace, String propertyName, T defaultValue, IAsyncResultHandler<T> handler) {
        QName qname = new QName(namespace, propertyName);
        if (this.getCache().containsKey((Object)qname)) {
            try {
                Object rval = this.getCache().get((Object)qname);
                handler.handle((Object)AsyncResultImpl.create((Object)rval));
            }
            catch (Exception e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        } else {
            handler.handle((Object)AsyncResultImpl.create(defaultValue));
        }
    }

    public <T> void setProperty(String namespace, String propertyName, T value, IAsyncResultHandler<Void> handler) {
        QName qname = new QName(namespace, propertyName);
        try {
            this.getCache().put((Object)qname, value);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void clearProperty(String namespace, String propertyName, IAsyncResultHandler<Void> handler) {
        QName qname = new QName(namespace, propertyName);
        try {
            this.getCache().remove((Object)qname);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }
}

