/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public abstract class AbstractInfinispanComponent {
    private String cacheContainer;
    private String cacheName;
    private Cache<Object, Object> cache;

    public AbstractInfinispanComponent(Map<String, String> config, String defaultCacheContainer, String defaultCache) {
        this.cacheContainer = defaultCacheContainer;
        this.cacheName = defaultCache;
        if (config.containsKey("cache-container")) {
            this.cacheContainer = config.get("cache-container");
        }
        if (config.containsKey("cache")) {
            this.cacheName = config.get("cache");
        }
    }

    protected Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

