/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.DependsOnComponents;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalReadStream;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.engine.ispn.AbstractInfinispanComponent;
import io.apiman.gateway.engine.ispn.InfinispanCacheEntry;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

@DependsOnComponents(value={IBufferFactoryComponent.class})
public class InfinispanCacheStoreComponent
extends AbstractInfinispanComponent
implements ICacheStoreComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "caching";
    private Object mutex = new Object();
    private IBufferFactoryComponent bufferFactory;

    public InfinispanCacheStoreComponent() {
        this(Collections.EMPTY_MAP);
    }

    public InfinispanCacheStoreComponent(Map<String, String> config) {
        super(config, DEFAULT_CACHE_CONTAINER, DEFAULT_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void put(String cacheKey, T jsonObject, long timeToLive) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            InfinispanCacheEntry entry = (InfinispanCacheEntry)this.getCache().get((Object)cacheKey);
            if (entry == null) {
                entry = new InfinispanCacheEntry();
            }
            entry.setHead(jsonObject);
            entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
            this.getCache().put((Object)cacheKey, (Object)entry);
        }
    }

    public <T> ISignalWriteStream putBinary(final String cacheKey, final T jsonObject, final long timeToLive) throws IOException {
        final IApimanBuffer dataBuffer = this.bufferFactory.createBuffer(0);
        return new ISignalWriteStream(){
            private boolean finished = false;
            private boolean aborted = false;

            public void abort() {
                this.aborted = true;
                this.finished = false;
            }

            public boolean isFinished() {
                return this.finished;
            }

            public void write(IApimanBuffer chunk) {
                dataBuffer.append(chunk);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void end() {
                if (!this.aborted) {
                    Object object = InfinispanCacheStoreComponent.this.mutex;
                    synchronized (object) {
                        InfinispanCacheEntry entry = (InfinispanCacheEntry)InfinispanCacheStoreComponent.this.getCache().get((Object)cacheKey);
                        if (entry == null) {
                            entry = new InfinispanCacheEntry();
                        }
                        entry.setHead(jsonObject);
                        entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
                        entry.setData(dataBuffer.getBytes());
                        InfinispanCacheStoreComponent.this.getCache().put((Object)cacheKey, (Object)entry);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void get(String cacheKey, Class<T> type, IAsyncResultHandler<T> handler) {
        Object rval;
        Object object = this.mutex;
        synchronized (object) {
            InfinispanCacheEntry entry = (InfinispanCacheEntry)this.getCache().get((Object)cacheKey);
            if (entry != null) {
                if (System.currentTimeMillis() >= entry.getExpiresOn()) {
                    this.getCache().remove((Object)cacheKey);
                    rval = null;
                } else {
                    rval = entry.getHead();
                }
            } else {
                rval = null;
            }
        }
        handler.handle((Object)AsyncResultImpl.create((Object)rval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void getBinary(String cacheKey, Class<T> type, IAsyncResultHandler<ISignalReadStream<T>> handler) {
        ISignalReadStream rval;
        Object object = this.mutex;
        synchronized (object) {
            InfinispanCacheEntry entry = (InfinispanCacheEntry)this.getCache().get((Object)cacheKey);
            if (entry != null) {
                if (entry.getExpiresOn() <= System.currentTimeMillis()) {
                    this.getCache().remove((Object)cacheKey);
                    rval = null;
                } else {
                    final Object head = entry.getHead();
                    final IApimanBuffer dataBuffer = this.bufferFactory.createBuffer(entry.getData());
                    rval = new ISignalReadStream<T>(){
                        boolean finished = false;
                        IAsyncHandler<IApimanBuffer> bodyHandler;
                        IAsyncHandler<Void> endHandler;

                        public void bodyHandler(IAsyncHandler<IApimanBuffer> bodyHandler) {
                            this.bodyHandler = bodyHandler;
                        }

                        public void endHandler(IAsyncHandler<Void> endHandler) {
                            this.endHandler = endHandler;
                        }

                        public T getHead() {
                            return head;
                        }

                        public boolean isFinished() {
                            return this.finished;
                        }

                        public void abort() {
                            this.finished = true;
                        }

                        public void transmit() {
                            this.bodyHandler.handle((Object)dataBuffer);
                            this.endHandler.handle(null);
                        }
                    };
                }
            } else {
                rval = null;
            }
        }
        handler.handle((Object)AsyncResultImpl.create(rval));
    }

    public void setBufferFactory(IBufferFactoryComponent bufferFactory) {
        this.bufferFactory = bufferFactory;
    }
}

