/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.osgi.policy;

import io.apiman.gateway.engine.beans.exceptions.PolicyNotFoundException;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class OSGIPolicyFactory
implements IPolicyFactory {
    public IPolicy newPolicy(String policyImpl) throws PolicyNotFoundException {
        if (policyImpl == null) {
            throw new PolicyNotFoundException(policyImpl);
        }
        try {
            if (policyImpl.startsWith("class:")) {
                String classname = policyImpl.substring(6);
                Bundle bundle = FrameworkUtil.getBundle(OSGIPolicyFactory.class);
                if (bundle != null) {
                    ServiceReference[] serviceReferences;
                    BundleContext context;
                    if (bundle.getState() == 4) {
                        bundle.start();
                    }
                    if ((context = bundle.getBundleContext()) != null && (serviceReferences = context.getServiceReferences(IPolicy.class.getName(), null)) != null) {
                        for (ServiceReference serviceReference : serviceReferences) {
                            IPolicy service = (IPolicy)context.getService(serviceReference);
                            if (!service.getClass().getName().equals(classname)) continue;
                            return service;
                        }
                    }
                }
                throw new PolicyNotFoundException(classname);
            }
            throw new PolicyNotFoundException(policyImpl);
        }
        catch (Exception e) {
            throw new PolicyNotFoundException(policyImpl, (Throwable)e);
        }
    }
}

