/*
 * Copyright 2018 Pete Cornish
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.apiman.gateway.engine.redis;

import io.apiman.gateway.engine.redis.common.RedisBackingStoreProvider;
import io.apiman.gateway.engine.storage.component.AbstractRateLimiterComponent;

import java.util.Map;

/**
 * Rate limiter component backed by Redis.
 *
 * @author Pete Cornish
 */
public class RedisRateLimiterComponent extends AbstractRateLimiterComponent {
    /**
     * Constructor.
     */
    public RedisRateLimiterComponent(Map<String, String> componentConfig) {
        super(new RedisBackingStoreProvider(componentConfig));
    }
}
