/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.redis.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apiman.gateway.engine.storage.store.IBackingStore;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;

public class RedisBackingStore
implements IBackingStore {
    private final RedissonClient client;
    private final String prefix;

    public RedisBackingStore(RedissonClient client, String prefix) {
        this.client = client;
        this.prefix = prefix;
    }

    private <T> T onMap(Function<RMapCache<String, String>, T> func) {
        RMapCache map = this.client.getMapCache(this.prefix);
        return func.apply((RMapCache<String, String>)map);
    }

    private void withMap(Consumer<RMapCache<String, String>> consumer) {
        RMapCache map = this.client.getMapCache(this.prefix);
        consumer.accept((RMapCache<String, String>)map);
    }

    public void put(String key, Object value, long ttl) {
        this.withMap(map -> {
            try {
                String raw = Objects.isNull(value) ? null : (value.getClass().isPrimitive() || value instanceof String ? value.toString() : BackingStoreUtil.JSON_MAPPER.writeValueAsString(value));
                map.put((Object)key, (Object)raw, ttl, TimeUnit.SECONDS);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Error setting value for key '%s'", key), e);
            }
        });
    }

    public <T> T get(String key, Class<T> type) {
        return (T)this.onMap(map -> {
            try {
                String raw = (String)map.get((Object)key);
                if (Objects.isNull(raw)) {
                    return null;
                }
                if (type.isPrimitive() || type.isAssignableFrom(String.class)) {
                    return BackingStoreUtil.readPrimitive((Class)type, (String)raw);
                }
                return BackingStoreUtil.JSON_MAPPER.readValue(raw, type);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error reading value for key '%s'", key), e);
            }
        });
    }

    public void remove(String key) {
        this.withMap(map -> {
            try {
                map.remove((Object)key);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error removing value for key '%s'", key), e);
            }
        });
    }

    public boolean containsKey(String key) {
        return this.onMap(map -> Objects.nonNull(map.get((Object)key)));
    }
}

