/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.redis.common;

import io.apiman.gateway.engine.redis.common.RedisBackingStore;
import io.apiman.gateway.engine.redis.common.RedisClientManager;
import io.apiman.gateway.engine.storage.store.IBackingStoreProvider;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RedisBackingStoreProvider
implements IBackingStoreProvider<RedisBackingStore> {
    public static final String CONFIG_FILE = "config.file";
    private final RedisClientManager clientManager;

    public RedisBackingStoreProvider(Map<String, String> componentConfig) {
        this(RedisClientManager.DEFAULT_MANAGER, componentConfig);
    }

    public RedisBackingStoreProvider(RedisClientManager clientManager, Map<String, String> componentConfig) {
        this.clientManager = clientManager;
        String configFilePath = componentConfig.get(CONFIG_FILE);
        if (StringUtils.isNotBlank((CharSequence)configFilePath)) {
            clientManager.setConfigFile(Paths.get(configFilePath, new String[0]));
        }
    }

    public RedisBackingStore get(String storeName) {
        return this.clientManager.getRedis(storeName);
    }
}

