/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.redis.common;

import io.apiman.gateway.engine.redis.common.RedisBackingStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.Config;

public final class RedisClientManager {
    public static final RedisClientManager DEFAULT_MANAGER = new RedisClientManager();
    private final Object mutex = new Object();
    private Config overrideConfig;
    private File configFile;
    private RedissonClient client;

    public void setConfigFile(Path configFilePath) {
        this.configFile = configFilePath.toFile();
    }

    public void setOverrideConfig(Config overrideConfig) {
        this.overrideConfig = overrideConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisBackingStore getRedis(String storeName) {
        if (Objects.isNull(this.client)) {
            Object object = this.mutex;
            synchronized (object) {
                if (Objects.isNull(this.client)) {
                    Config config;
                    if (Objects.nonNull(this.overrideConfig)) {
                        config = this.overrideConfig;
                    } else if (Objects.nonNull(this.configFile)) {
                        config = this.loadConfigFromFile();
                    } else {
                        throw new IllegalStateException("No Redisson configuration provided");
                    }
                    config.setCodec((Codec)new StringCodec());
                    this.client = Redisson.create((Config)config);
                }
            }
        }
        return new RedisBackingStore(this.client, storeName);
    }

    private Config loadConfigFromFile() {
        if (this.configFile.exists()) {
            try {
                return Config.fromJSON((File)this.configFile);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading Redisson configuration file: %s", this.configFile), e);
            }
        }
        throw new RuntimeException(String.format("Redisson configuration file: '%s' does not exist", this.configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (Objects.nonNull(this.client)) {
            Object object = this.mutex;
            synchronized (object) {
                if (Objects.nonNull(this.client)) {
                    this.client.shutdown();
                    this.client = null;
                }
            }
        }
    }
}

