/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.components;

import io.apiman.gateway.engine.components.http.IHttpClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;

public class HttpClientResponseImpl
implements IHttpClientResponse {
    private HttpURLConnection connection;

    public HttpClientResponseImpl(HttpURLConnection connection) {
        this.connection = connection;
    }

    public int getResponseCode() {
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResponseMessage() {
        try {
            return this.connection.getResponseMessage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHeader(String headerName) {
        return this.connection.getHeaderField(headerName);
    }

    public String getBody() {
        InputStream body = null;
        try {
            body = this.connection.getInputStream();
            if (body != null) {
                StringBuilderWriter writer = new StringBuilderWriter();
                try {
                    IOUtils.copy((InputStream)body, (Writer)writer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String string = writer.getBuilder().toString();
                return string;
            }
            String writer = null;
            return writer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)body);
        }
    }

    public void close() {
        try {
            IOUtils.closeQuietly((InputStream)this.connection.getInputStream());
            this.connection.disconnect();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

