/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet;

import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.PolicyFailureType;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.io.ByteBuffer;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.platforms.servlet.GatewayThreadContext;
import io.apiman.gateway.platforms.servlet.i18n.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class GatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 958726685958622333L;
    private static final ObjectMapper mapper = new ObjectMapper();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "GET");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "POST");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "PUT");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "DELETE");
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "OPTIONS");
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "HEAD");
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "TRACE");
    }

    protected void doAction(final HttpServletRequest req, final HttpServletResponse resp, String action) {
        ServiceRequest srequest = null;
        try {
            srequest = this.readRequest(req);
            srequest.setType(action);
        }
        catch (Exception e) {
            this.writeError(resp, e);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        IServiceRequestExecutor executor = this.getEngine().executor(srequest, (IAsyncResultHandler)new IAsyncResultHandler<IEngineResult>(){

            public void handle(IAsyncResult<IEngineResult> asyncResult) {
                if (asyncResult.isSuccess()) {
                    IEngineResult engineResult = (IEngineResult)asyncResult.getResult();
                    if (engineResult.isResponse()) {
                        try {
                            GatewayServlet.this.writeResponse(resp, engineResult.getServiceResponse());
                            final ServletOutputStream outputStream = resp.getOutputStream();
                            engineResult.bodyHandler((IAsyncHandler)new IAsyncHandler<IApimanBuffer>(){

                                public void handle(IApimanBuffer chunk) {
                                    try {
                                        if (chunk instanceof ByteBuffer) {
                                            byte[] buffer = (byte[])chunk.getNativeBuffer();
                                            outputStream.write(buffer, 0, chunk.length());
                                        } else {
                                            outputStream.write(chunk.getBytes());
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                            engineResult.endHandler((IAsyncHandler)new IAsyncHandler<Void>(){

                                public void handle(Void result) {
                                    try {
                                        resp.flushBuffer();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    finally {
                                        latch.countDown();
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            engineResult.abort();
                            latch.countDown();
                            throw new RuntimeException(e);
                        }
                    } else {
                        GatewayServlet.this.writeFailure(resp, engineResult.getPolicyFailure());
                        latch.countDown();
                    }
                } else {
                    GatewayServlet.this.writeError(resp, asyncResult.getError());
                    latch.countDown();
                }
            }
        });
        executor.streamHandler((IAsyncHandler)new IAsyncHandler<ISignalWriteStream>(){

            public void handle(ISignalWriteStream connectorStream) {
                try {
                    ServletInputStream is = req.getInputStream();
                    ByteBuffer buffer = new ByteBuffer(2048);
                    int numBytes = buffer.readFrom((InputStream)is);
                    while (numBytes != -1) {
                        connectorStream.write((IApimanBuffer)buffer);
                        numBytes = buffer.readFrom((InputStream)is);
                    }
                    connectorStream.end();
                }
                catch (IOException e) {
                    connectorStream.abort();
                    throw new RuntimeException(e);
                }
            }
        });
        executor.execute();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        GatewayThreadContext.reset();
    }

    protected abstract IEngine getEngine();

    protected ServiceRequest readRequest(HttpServletRequest request) throws Exception {
        ServiceRequestPathInfo pathInfo = GatewayServlet.parseServiceRequestPath(request.getPathInfo());
        if (pathInfo.orgId == null) {
            throw new Exception(Messages.i18n.format("GatewayServlet.InvalidServiceEndpoint", new Object[0]));
        }
        Map<String, String> queryParams = GatewayServlet.parseServiceRequestQueryParams(request.getQueryString());
        String apiKey = this.getApiKey(request, queryParams);
        ServiceRequest srequest = GatewayThreadContext.getServiceRequest();
        srequest.setApiKey(apiKey);
        srequest.setServiceOrgId(pathInfo.orgId);
        srequest.setServiceId(pathInfo.serviceId);
        srequest.setServiceVersion(pathInfo.serviceVersion);
        srequest.setDestination(pathInfo.resource);
        srequest.setQueryParams(queryParams);
        this.readHeaders(srequest, request);
        srequest.setRawRequest((Object)request);
        srequest.setRemoteAddr(request.getRemoteAddr());
        return srequest;
    }

    protected String getApiKey(HttpServletRequest request, Map<String, String> queryParams) {
        String apiKey = request.getHeader("X-API-Key");
        if (apiKey == null || apiKey.trim().length() == 0) {
            apiKey = queryParams.get("apikey");
        }
        return apiKey;
    }

    protected void readHeaders(ServiceRequest srequest, HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hname = (String)headerNames.nextElement();
            String hval = request.getHeader(hname);
            srequest.getHeaders().put(hname, hval);
        }
    }

    protected void writeResponse(HttpServletResponse response, ServiceResponse sresponse) {
        response.setStatus(sresponse.getCode());
        Map headers = sresponse.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String hname = (String)entry.getKey();
            String hval = (String)entry.getValue();
            response.setHeader(hname, hval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailure(HttpServletResponse resp, PolicyFailure policyFailure) {
        resp.setContentType("application/json");
        resp.setHeader("X-Policy-Failure-Type", String.valueOf(policyFailure.getType()));
        resp.setHeader("X-Policy-Failure-Message", policyFailure.getMessage());
        resp.setHeader("X-Policy-Failure-Code", String.valueOf(policyFailure.getFailureCode()));
        for (Map.Entry entry : policyFailure.getHeaders().entrySet()) {
            resp.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        int errorCode = 500;
        if (policyFailure.getType() == PolicyFailureType.Authentication) {
            errorCode = 401;
        } else if (policyFailure.getType() == PolicyFailureType.Authorization) {
            errorCode = 403;
        } else if (policyFailure.getType() == PolicyFailureType.NotFound) {
            errorCode = 404;
        }
        if (policyFailure.getType() == PolicyFailureType.Other && policyFailure.getResponseCode() >= 300) {
            errorCode = policyFailure.getResponseCode();
        }
        resp.setStatus(errorCode);
        try {
            mapper.writer().writeValue((OutputStream)resp.getOutputStream(), (Object)policyFailure);
            IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            this.writeError(resp, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeError(HttpServletResponse resp, Throwable error) {
        try {
            resp.setHeader("X-Exception", error.getMessage());
            resp.setStatus(500);
            ServletOutputStream outputStream = null;
            try {
                outputStream = resp.getOutputStream();
                PrintWriter writer = new PrintWriter((OutputStream)outputStream);
                error.printStackTrace(writer);
                writer.flush();
                outputStream.flush();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(error);
        }
    }

    protected static final ServiceRequestPathInfo parseServiceRequestPath(String pathInfo) {
        String[] split;
        ServiceRequestPathInfo info = new ServiceRequestPathInfo();
        if (pathInfo != null && (split = pathInfo.split("/")).length >= 4) {
            info.orgId = split[1];
            info.serviceId = split[2];
            info.serviceVersion = split[3];
            if (split.length > 4) {
                StringBuilder resource = new StringBuilder();
                for (int idx = 4; idx < split.length; ++idx) {
                    resource.append("/");
                    resource.append(split[idx]);
                }
                info.resource = resource.toString();
            }
        }
        return info;
    }

    protected static final Map<String, String> parseServiceRequestQueryParams(String queryString) {
        LinkedHashMap<String, String> rval = new LinkedHashMap<String, String>();
        if (queryString != null) {
            String[] pairSplit;
            try {
                queryString = URLDecoder.decode(queryString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (String paramPair : pairSplit = queryString.split("&")) {
                int idx = paramPair.indexOf("=");
                if (idx != -1) {
                    String key = paramPair.substring(0, idx);
                    String val = paramPair.substring(idx + 1);
                    rval.put(key, val);
                    continue;
                }
                rval.put(paramPair, null);
            }
        }
        return rval;
    }

    protected static class ServiceRequestPathInfo {
        public String orgId;
        public String serviceId;
        public String serviceVersion;
        public String resource;

        protected ServiceRequestPathInfo() {
        }
    }
}

