/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet;

import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;

public class GatewayThreadContext {
    private static final ThreadLocal<ServiceRequest> serviceRequest = new ThreadLocal();
    private static final ThreadLocal<ServiceResponse> serviceResponse = new ThreadLocal();
    private static final ThreadLocal<PolicyFailure> policyFailure = new ThreadLocal();

    public static final ServiceRequest getServiceRequest() {
        ServiceRequest request = serviceRequest.get();
        if (request == null) {
            request = new ServiceRequest();
            serviceRequest.set(request);
        }
        return request;
    }

    public static final ServiceResponse getServiceResponse() {
        ServiceResponse request = serviceResponse.get();
        if (request == null) {
            request = new ServiceResponse();
            serviceResponse.set(request);
        }
        return request;
    }

    public static final PolicyFailure getPolicyFailure() {
        PolicyFailure request = policyFailure.get();
        if (request == null) {
            request = new PolicyFailure();
            policyFailure.set(request);
        }
        return request;
    }

    public static final void reset() {
        ServiceRequest request = GatewayThreadContext.getServiceRequest();
        request.setApiKey(null);
        request.setDestination(null);
        request.getHeaders().clear();
        request.setRawRequest(null);
        request.setRemoteAddr(null);
        request.setType(null);
        request.setTransportSecure(false);
        ServiceResponse response = GatewayThreadContext.getServiceResponse();
        response.setCode(0);
        response.getHeaders().clear();
        response.setMessage(null);
        response.getAttributes().clear();
        PolicyFailure failure = GatewayThreadContext.getPolicyFailure();
        failure.setFailureCode(0);
        failure.setMessage(null);
        failure.setType(null);
        failure.getHeaders().clear();
    }
}

