/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.components;

import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.components.IPeriodicComponent;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PeriodicComponentImpl
implements IPeriodicComponent {
    private Timer timer = new Timer();
    private ConcurrentMap<Long, TimerTask> timerTaskMap = new ConcurrentHashMap<Long, TimerTask>();
    private AtomicInteger id = new AtomicInteger(0);

    public long setPeriodicTimer(long periodMillis, long initialDelayMillis, final IAsyncHandler<Long> periodicHandler) {
        final long timerId = this.id.incrementAndGet();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                periodicHandler.handle((Object)timerId);
            }
        };
        this.timerTaskMap.put(timerId, task);
        this.timer.schedule(task, initialDelayMillis, periodMillis);
        return timerId;
    }

    public long setOneshotTimer(long deltaMillis, final IAsyncHandler<Long> timerHandler) {
        final long timerId = this.id.incrementAndGet();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                timerHandler.handle((Object)timerId);
            }
        };
        this.timerTaskMap.put(timerId, task);
        this.timer.schedule(task, deltaMillis);
        return timerId;
    }

    public void cancelTimer(long timerId) {
        ((TimerTask)this.timerTaskMap.remove(timerId)).cancel();
    }

    public void cancelAll() {
        for (Map.Entry e : this.timerTaskMap.entrySet()) {
            ((TimerTask)this.timerTaskMap.remove(e)).cancel();
        }
    }
}

