/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.io;

import io.apiman.gateway.engine.io.IApimanBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteBuffer
implements IApimanBuffer {
    private byte[] buffer;
    private int bytesInBuffer = 0;

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
    }

    public ByteBuffer(String stringData) {
        this.buffer = stringData.getBytes();
        this.bytesInBuffer = this.buffer.length;
    }

    public ByteBuffer(String stringData, String enc) {
        try {
            this.buffer = stringData.getBytes(enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer(byte[] byteData) {
        this.buffer = Arrays.copyOf(byteData, byteData.length);
    }

    public Object getNativeBuffer() {
        return this.buffer;
    }

    public int length() {
        return this.bytesInBuffer;
    }

    public void insert(int index, IApimanBuffer buffer) {
        throw new RuntimeException("Not yet implemented");
    }

    public void insert(int index, IApimanBuffer buffer, int offset, int length) {
        throw new RuntimeException("Not yet implemented");
    }

    public void append(IApimanBuffer buffer) {
        throw new RuntimeException("Not yet implemented");
    }

    public void append(IApimanBuffer buffer, int offset, int length) {
        throw new RuntimeException("Not yet implemented");
    }

    public byte get(int index) {
        return this.buffer[index];
    }

    public void set(int index, byte b) {
        this.buffer[index] = b;
    }

    public void append(byte b) {
        byte[] bytes = new byte[]{b};
        this.append(bytes);
    }

    public byte[] getBytes() {
        byte[] rval = new byte[this.bytesInBuffer];
        System.arraycopy(this.buffer, 0, rval, 0, this.bytesInBuffer);
        return rval;
    }

    public byte[] getBytes(int start, int end) {
        int size = end - start - 1;
        byte[] rval = new byte[this.bytesInBuffer];
        System.arraycopy(this.buffer, start, rval, 0, size);
        return rval;
    }

    public void insert(int index, byte[] b) {
        throw new RuntimeException("Not yet implemented");
    }

    public void insert(int index, byte[] b, int offset, int length) {
        throw new RuntimeException("Not yet implemented");
    }

    public void append(byte[] bytes) {
        int requiredBytes = this.bytesInBuffer + bytes.length;
        if (requiredBytes > this.buffer.length) {
            byte[] oldbuffer = this.buffer;
            this.buffer = new byte[requiredBytes];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, this.bytesInBuffer);
        }
        System.arraycopy(bytes, 0, this.buffer, this.bytesInBuffer, bytes.length);
        this.bytesInBuffer = requiredBytes;
    }

    public void append(byte[] bytes, int offset, int length) {
        int requiredBytes = this.bytesInBuffer + length;
        if (requiredBytes > this.buffer.length) {
            byte[] oldbuffer = this.buffer;
            this.buffer = new byte[requiredBytes];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, this.bytesInBuffer);
        }
        System.arraycopy(bytes, offset, this.buffer, this.bytesInBuffer, length);
        this.bytesInBuffer = requiredBytes;
    }

    public String getString(int start, int end) {
        return new String(this.getBytes(start, end));
    }

    public String getString(int start, int end, String encoding) {
        try {
            return new String(this.getBytes(start, end), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void insert(int index, String string) {
        throw new RuntimeException("Not yet implemented");
    }

    public void insert(int index, String string, String encoding) {
        throw new RuntimeException("Not yet implemented");
    }

    public void append(String string) {
        byte[] bytes = string.getBytes();
        this.append(bytes);
    }

    public void append(String string, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = string.getBytes(encoding);
        this.append(bytes);
    }

    public String toString(String encoding) {
        try {
            return new String(this.buffer, 0, this.bytesInBuffer, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return new String(this.buffer, 0, this.bytesInBuffer);
    }

    public int getBytesInBuffer() {
        return this.bytesInBuffer;
    }

    public int readFrom(InputStream stream) throws IOException {
        this.bytesInBuffer = stream.read(this.buffer);
        return this.bytesInBuffer;
    }
}

