/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.connectors;

import io.apiman.common.config.options.BasicAuthOptions;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.auth.RequiredAuthType;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.beans.exceptions.ConnectorException;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.platforms.servlet.GatewayThreadContext;
import io.apiman.gateway.platforms.servlet.connectors.ssl.SSLSessionStrategy;
import io.apiman.gateway.platforms.servlet.io.ByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class HttpServiceConnection
implements IServiceConnection,
IServiceConnectionResponse {
    private static final Set<String> SUPPRESSED_HEADERS = new HashSet<String>();
    private ServiceRequest request;
    private Service service;
    private RequiredAuthType requiredAuthType;
    private SSLSessionStrategy sslStrategy;
    private IAsyncResultHandler<IServiceConnectionResponse> responseHandler;
    private boolean connected;
    private HttpURLConnection connection;
    private OutputStream outputStream;
    private IAsyncHandler<IApimanBuffer> bodyHandler;
    private IAsyncHandler<Void> endHandler;
    private ServiceResponse response;

    public HttpServiceConnection(ServiceRequest request, Service service, RequiredAuthType requiredAuthType, SSLSessionStrategy sslStrategy, IAsyncResultHandler<IServiceConnectionResponse> handler) throws ConnectorException {
        this.request = request;
        this.service = service;
        this.requiredAuthType = requiredAuthType;
        this.sslStrategy = sslStrategy;
        this.responseHandler = handler;
        try {
            this.connect();
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private void connect() throws ConnectorException {
        try {
            BasicAuthOptions options;
            String endpoint = this.service.getEndpoint();
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            if (this.request.getDestination() != null) {
                endpoint = endpoint + this.request.getDestination();
            }
            if (this.request.getQueryParams() != null && !this.request.getQueryParams().isEmpty()) {
                String delim = "?";
                for (Map.Entry entry : this.request.getQueryParams().entrySet()) {
                    endpoint = endpoint + delim + (String)entry.getKey();
                    if (entry.getValue() != null) {
                        endpoint = endpoint + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
                    }
                    delim = "&";
                }
            }
            URL url = new URL(endpoint);
            this.connection = (HttpURLConnection)url.openConnection();
            boolean isSsl = this.connection instanceof HttpsURLConnection;
            if (this.requiredAuthType == RequiredAuthType.MTLS && !isSsl) {
                throw new ConnectorException("Mutually authenticating TLS requested, but insecure endpoint protocol was indicated.");
            }
            if (this.requiredAuthType == RequiredAuthType.BASIC && (options = new BasicAuthOptions(this.service.getEndpointProperties())).getUsername() != null && options.getPassword() != null) {
                if (options.isRequireSSL() && !isSsl) {
                    throw new ConnectorException("Endpoint security requested (BASIC auth) but endpoint is not secure (SSL).");
                }
                String up = options.getUsername() + ':' + options.getPassword();
                StringBuilder builder = new StringBuilder();
                builder.append("BASIC ");
                builder.append(Base64.encodeBase64String((byte[])up.getBytes()));
                this.connection.setRequestProperty("Authorization", builder.toString());
            }
            if (isSsl) {
                HttpsURLConnection https = (HttpsURLConnection)this.connection;
                SSLSocketFactory socketFactory = this.sslStrategy.getSocketFactory();
                https.setSSLSocketFactory(socketFactory);
                https.setHostnameVerifier(this.sslStrategy.getHostnameVerifier());
            }
            this.connection.setReadTimeout(15000);
            this.connection.setConnectTimeout(10000);
            if (this.request.getType().equalsIgnoreCase("PUT") || this.request.getType().equalsIgnoreCase("POST")) {
                this.connection.setDoOutput(true);
            } else {
                this.connection.setDoOutput(false);
            }
            this.connection.setDoInput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestMethod(this.request.getType());
            for (Map.Entry entry : this.request.getHeaders().entrySet()) {
                String hname = (String)entry.getKey();
                String hval = (String)entry.getValue();
                if (SUPPRESSED_HEADERS.contains(hname)) continue;
                this.connection.setRequestProperty(hname, hval);
            }
            this.connection.connect();
            this.connected = true;
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void bodyHandler(IAsyncHandler<IApimanBuffer> bodyHandler) {
        this.bodyHandler = bodyHandler;
    }

    public void endHandler(IAsyncHandler<Void> endHandler) {
        this.endHandler = endHandler;
    }

    public ServiceResponse getHead() {
        return this.response;
    }

    public boolean isFinished() {
        return !this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void abort() {
        try {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            if (this.connection != null) {
                IOUtils.closeQuietly((OutputStream)this.outputStream);
                IOUtils.closeQuietly((InputStream)this.connection.getInputStream());
                this.connected = false;
                this.connection.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(IApimanBuffer chunk) {
        try {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.connection.getOutputStream();
            }
            if (chunk instanceof ByteBuffer) {
                byte[] buffer = (byte[])chunk.getNativeBuffer();
                this.outputStream.write(buffer, 0, chunk.length());
            } else {
                this.outputStream.write(chunk.getBytes());
            }
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void end() {
        try {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            this.outputStream = null;
            this.response = GatewayThreadContext.getServiceResponse();
            Map<String, List<String>> headerFields = this.connection.getHeaderFields();
            for (String headerName : headerFields.keySet()) {
                if (headerName == null) continue;
                this.response.getHeaders().put(headerName, this.connection.getHeaderField(headerName));
            }
            this.response.setCode(this.connection.getResponseCode());
            this.response.setMessage(this.connection.getResponseMessage());
            this.responseHandler.handle((Object)AsyncResultImpl.create((Object)this));
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void transmit() {
        try {
            if (!this.connected) {
                throw new IOException("Not connected.");
            }
            InputStream is = this.connection.getInputStream();
            ByteBuffer buffer = new ByteBuffer(2048);
            int numBytes = buffer.readFrom(is);
            while (numBytes != -1) {
                this.bodyHandler.handle((Object)buffer);
                numBytes = buffer.readFrom(is);
            }
            IOUtils.closeQuietly((InputStream)is);
            this.connection.disconnect();
            this.connected = false;
            this.endHandler.handle(null);
        }
        catch (Throwable e) {
            if (this.connected) {
                this.abort();
            }
            throw new RuntimeException(e);
        }
    }

    static {
        SUPPRESSED_HEADERS.add("Transfer-Encoding");
        SUPPRESSED_HEADERS.add("Content-Length");
        SUPPRESSED_HEADERS.add("X-API-Key");
    }
}

