/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.connectors.ssl;

import io.apiman.common.config.options.TLSOptions;
import io.apiman.gateway.platforms.servlet.connectors.ssl.CipherSelectingSSLSocketFactory;
import io.apiman.gateway.platforms.servlet.connectors.ssl.SSLSessionStrategy;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Args;

public class SSLSessionStrategyFactory {
    private static final HostnameVerifier ALLOW_ANY = new AllowAnyVerifier();
    private static final TrustStrategy SELF_SIGNED = new TrustSelfSignedStrategy();

    private SSLSessionStrategyFactory() {
    }

    public static SSLSessionStrategy buildStandard(TLSOptions optionsMap) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        String[] allowedProtocols = SSLSessionStrategyFactory.optionalVar(optionsMap.getAllowedProtocols(), SSLSessionStrategyFactory.getDefaultProtocols());
        String[] allowedCiphers = SSLSessionStrategyFactory.optionalVar(optionsMap.getAllowedCiphers(), SSLSessionStrategyFactory.getDefaultCipherSuites());
        return SSLSessionStrategyFactory.build(optionsMap.getTrustStore(), optionsMap.getTrustStorePassword(), null, null, null, null, allowedProtocols, allowedCiphers, optionsMap.isAllowAnyHost(), optionsMap.isTrustSelfSigned());
    }

    public static SSLSessionStrategy buildMutual(TLSOptions optionsMap) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        Args.notNull((Object)optionsMap.getKeyStore(), (String)"KeyStore");
        Args.notEmpty((CharSequence)optionsMap.getKeyStore(), (String)"KeyStore must not be empty");
        String[] allowedProtocols = SSLSessionStrategyFactory.optionalVar(optionsMap.getAllowedProtocols(), SSLSessionStrategyFactory.getDefaultProtocols());
        String[] allowedCiphers = SSLSessionStrategyFactory.optionalVar(optionsMap.getAllowedCiphers(), SSLSessionStrategyFactory.getDefaultCipherSuites());
        return SSLSessionStrategyFactory.build(optionsMap.getTrustStore(), optionsMap.getTrustStorePassword(), optionsMap.getKeyStore(), optionsMap.getKeyStorePassword(), optionsMap.getKeyAliases(), optionsMap.getKeyPassword(), allowedProtocols, allowedCiphers, optionsMap.isAllowAnyHost(), optionsMap.isTrustSelfSigned());
    }

    public static SSLSessionStrategy build(String trustStore, String trustStorePassword, String keyStore, String keyStorePassword, String[] keyAliases, String keyPassword, String[] allowedProtocols, String[] allowedCiphers, boolean allowAnyHostname, boolean trustSelfSigned) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        Args.notNull((Object)allowedProtocols, (String)"Allowed protocols");
        Args.notNull((Object)allowedCiphers, (String)"Allowed ciphers");
        TrustStrategy trustStrategy = trustSelfSigned ? SELF_SIGNED : null;
        HostnameVerifier hostnameVerifier = allowAnyHostname ? ALLOW_ANY : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        SelectByAlias privateKeyStrategy = keyAliases == null ? null : new SelectByAlias(keyAliases);
        boolean clientAuth = keyStore != null;
        SSLContextBuilder builder = SSLContexts.custom();
        if (trustStore != null) {
            builder.loadTrustMaterial(new File(trustStore), trustStorePassword.toCharArray(), (org.apache.http.ssl.TrustStrategy)trustStrategy);
        }
        if (keyStore != null) {
            char[] ksp = keyStorePassword == null ? null : keyStorePassword.toCharArray();
            char[] kp = keyPassword == null ? null : keyPassword.toCharArray();
            builder.loadKeyMaterial(new File(keyStore), ksp, kp, (PrivateKeyStrategy)privateKeyStrategy);
        }
        SSLContext sslContext = builder.build();
        return new SSLSessionStrategy(hostnameVerifier, new CipherSelectingSSLSocketFactory(sslContext.getSocketFactory(), allowedCiphers, allowedProtocols, clientAuth));
    }

    public static SSLSessionStrategy buildUnsafe() {
        System.err.println("ATTENTION: SSLSessionStrategy will trust *any* certificate. This is extremely unsafe for production. Caveat utilitor!");
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return new SSLSessionStrategy(ALLOW_ANY, sslContext.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] getDefaultCipherSuites() throws NoSuchAlgorithmException {
        return SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
    }

    private static String[] getDefaultProtocols() throws NoSuchAlgorithmException {
        return SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
    }

    private static String[] optionalVar(String[] arr, String[] defaultArr) {
        if (arr == null || arr.length == 0) {
            return defaultArr;
        }
        return arr;
    }

    private static final class SelectByAlias
    implements PrivateKeyStrategy {
        private Set<String> keyAliases = new HashSet<String>();

        public SelectByAlias(String[] keyAliases) {
            for (String k : keyAliases) {
                this.keyAliases.add(k);
            }
        }

        public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
            for (String k : aliases.keySet()) {
                if (!this.keyAliases.contains(k)) continue;
                return k;
            }
            return null;
        }
    }

    private static final class AllowAnyVerifier
    implements HostnameVerifier {
        private AllowAnyVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

