/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.servlet.connectors;

import io.apiman.common.config.options.TLSOptions;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.IServiceConnector;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.auth.RequiredAuthType;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.ConnectorException;
import io.apiman.gateway.platforms.servlet.connectors.HttpServiceConnection;
import io.apiman.gateway.platforms.servlet.connectors.ssl.SSLSessionStrategy;
import io.apiman.gateway.platforms.servlet.connectors.ssl.SSLSessionStrategyFactory;
import java.util.Map;

public class HttpConnectorFactory
implements IConnectorFactory {
    private SSLSessionStrategy standardSslStrategy;
    private SSLSessionStrategy mutualAuthSslStrategy;
    private TLSOptions tlsOptions;

    public HttpConnectorFactory(Map<String, String> config) {
        this.tlsOptions = new TLSOptions(config);
    }

    public IServiceConnector createConnector(ServiceRequest request, final Service service, final RequiredAuthType requiredAuthType) {
        return new IServiceConnector(){

            public IServiceConnection connect(ServiceRequest request, IAsyncResultHandler<IServiceConnectionResponse> handler) throws ConnectorException {
                HttpServiceConnection connection = new HttpServiceConnection(request, service, requiredAuthType, HttpConnectorFactory.this.getSslStrategy(requiredAuthType), handler);
                return connection;
            }
        };
    }

    protected SSLSessionStrategy getSslStrategy(RequiredAuthType authType) {
        try {
            if (authType == RequiredAuthType.MTLS) {
                if (this.mutualAuthSslStrategy == null) {
                    this.mutualAuthSslStrategy = SSLSessionStrategyFactory.buildMutual(this.tlsOptions);
                }
                return this.mutualAuthSslStrategy;
            }
            if (this.standardSslStrategy == null) {
                this.standardSslStrategy = this.tlsOptions.isDevMode() ? SSLSessionStrategyFactory.buildUnsafe() : SSLSessionStrategyFactory.buildStandard(this.tlsOptions);
            }
            return this.standardSslStrategy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

